<?php
session_start();

// Require user to be logged in
if (!isset($_SESSION['username'])) {
  header("Location: LoginPage.php");
  exit();
}

// Check for session hijacking (IP address change)
if (!isset($_SESSION['user_ip'])) {
  $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
} elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
  session_unset();
  session_destroy();
  header("Location: LoginPage.php");
  exit();
}

// Session timeout logic
$timeout = 600; // 10 minutes
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
  session_unset();
  session_destroy();
  header("Location: LoginPage.php");
  exit();
}
$_SESSION['last_activity'] = time();

// Reset session data manually with ?reset=true
if (isset($_GET['reset'])) {
  unset($_SESSION['temp_row']);
  unset($_SESSION['fee_row']);
  header("Location: AddCertificateShortCourses.php");
  exit();
}

// Process Course form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submitCourse'])) {
  $_SESSION['temp_row'] = [
    'courseName' => $_POST['courseName'],
    'abbreviation' => $_POST['abbreviation'],
    'batch' => $_POST['batch'],
    'duration' => $_POST['duration'],
  ];
  header("Location: AddCertificateShortCourses.php");
  exit();
}

// Process Fee form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submitFee'])) {
  $_SESSION['fee_row'] = [
    'course' => $_POST['course'],
    'batch' => $_POST['batch'],
    'startDate' => $_POST['startDate'],
    'endDate' => $_POST['endDate'],
    'monthlyFee' => $_POST['monthlyFee'],
    'totalFee' => $_POST['totalFee'],
    'discount' => $_POST['discount'],
    'studentDiscount' => $_POST['studentDiscount'],
    'professionalDiscount' => $_POST['professionalDiscount'],
    'showDateFrom' => $_POST['showDateFrom'],
    'showDateTo' => $_POST['showDateTo'],
  ];
  header("Location: AddCertificateShortCourses.php");
  exit();
}

// Retrieve submitted data for display
$storedRow = $_SESSION['temp_row'] ?? null;
$feeData = $_SESSION['fee_row'] ?? [];

// Clear after displaying once
unset($_SESSION['temp_row']);
unset($_SESSION['fee_row']);
?>

<!DOCTYPE html>
<html lang="en">
 <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
      rel="stylesheet"
    />
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
      rel="stylesheet"
      integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
      crossorigin="anonymous"
    />
    <link rel="stylesheet" href="assets/css/styles.css" />
    <style>
      /* .custom-input { 
        padding: 8px; 
        border-radius: 8px; 
        width: 100%; 
      } */
      /* .table-header {
        padding: 10px;
        border: 1px solid #ccc;
        font-weight: bold;
      }
      .table-cell {
        padding: 10px;
        border: 1px solid #ccc;
      } */
      table { 
        width: 100%; 
        border-collapse: collapse; 
        margin-top: 20px; 
      }    
      th, td { 
        border: 1px solid #ccc; 
        padding: 10px; 
        text-align: center; 
      }       
      th { 
        background-color: #a10101; 
        color: white; 
      }
    </style>
    <title>NED ACADEMY</title>
  </head>
  <body>
    <div class="form-container">
      <div class="container" style="padding-top: 130px; padding-bottom: 100px">
        <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
          <div class="container1">
            <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
              <div class="py-2 text-left">
                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
              </div>
              <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: 0; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">ADD CERTIFICATE COURSE</h2>
              <div style="display: flex; justify-content: flex-end; padding: 10px;">
                <button class="logout-btn" style="background: none; border: none;">
                  <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 18px; right: 10px;">
                    LOGOUT
                  </a>
                </button>
              </div>
              <div style="padding-left: 30px;">
                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 56px;">
                  BACK
                </button>
              </div>
            </div>
          </div>

          <div class="container2">
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
              <div class="form-row">
                <div style="width: 100%;">
                  <label class="text">Course Name</label><br>
                  <input class="custom-select-cc" type="text" name="courseName" placeholder="Certificate Course" required>
                </div>
                <div>
                  <label class="text">Abbreviation</label><br>
                  <input class="custom-select-abb" type="text" name="abbreviation" placeholder="Abbreviation" required>
                </div>
                <div>
                  <label class="text">Batch</label><br>
                  <input class="custom-select-abb" type="text" name="batch" placeholder="Batch-1" required>
                </div>
                <div>
                  <label class="text">Duration</label><br>
                  <div style="position: relative; top: -1px; width: 150%;">
                    <select name="duration" class="custom-select-duration" style="height: calc(1.6em + .75rem + 2px); padding: 0px; padding-left: 8px;" required>
                      <option value="0" >Select</option>
                      <option value="1 Week">1 Week </option>
                      <option value="2  Week">2  Week </option>
                      <option value="3  Week">3  Week </option>
                      <option value="4  Week">4  Week </option>
                      <option value="5  Week">5  Week </option>
                      <option value="6  Week">6  Week </option>
                      <option value="7  Week">7  Week </option>
                      <option value="8  Week">8  Week </option>
                      <option value="9  Week">9  Week </option>
                      <option value="10  Week">10  Week </option>
                      <option value="11  Week">11  Week </option>
                      <option value="12  Week">12  Week </option>
                      <option value="13  Week">13  Week </option>
                      <option value="14  Week">14  Week </option>
                      <option value="15  Week">15  Week </option>
                      <option value="16  Week">16  Week </option>
                      <option value="24  Week">24  Week </option>
                      <option value="1 Day">1 Day </option>
                      <option value="2 Day">2 Day </option>
                      <option value="3 Day">3 Day </option>
                      <option value="4 Day">4 Day </option>
                      <option value="5 Day">5 Day </option>
                    </select>
                  </div>
                </div>
              </div>
              <div style="text-align: center; padding-bottom: 30px;">
                <input type="submit" name="submitCourse" value="ADD ROW" class="add-row-btn">
              </div>
            </form>

            <?php if ($storedRow): ?>
            <div style="padding-bottom: 40px; padding-left: 110px; padding-right: 58px;">
              <table>
                <thead>
                  <tr style="background-color: #a10101; color: white;">
                    <th>#</th>
                    <th>Course Name</th>
                    <th>Abbreviation</th>
                    <th>Batch</th>
                    <th>Duration</th>
                  </tr>
                </thead>
                <tbody>
                  <!-- Repeat rows dynamically -->
                  <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                    <td>1</td>
                    <td><?= htmlspecialchars($storedRow['courseName']) ?></td>
                    <td><?= htmlspecialchars($storedRow['abbreviation']) ?></td>
                    <td><?= htmlspecialchars($storedRow['batch']) ?></td>
                    <td><?= htmlspecialchars($storedRow['duration']) ?></td>
                    <td style="background: none; border: none;"><button class="update-btn">UPDATE</button></td>
                  </tr>
                </tbody>
              </table>
            </div>
            <?php endif; ?>
          </div>

          <div class="container3">
            <div style="background-color: white;">
              <h2 class="text-center" style="color: rgba(28, 28, 78, 0.92); margin: 0; font-size: xx-large; padding-bottom: 30px; padding-top: 30px; font-weight: 700;">
                ADD CERTIFICATE FEE & DATE
              </h2>
            </div>
          </div>

          <div class="container4" style="background-color: #f5f7fa;">
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
              <div class="container-fluid">
                <div align="center">
                  <div style="display: flex; gap: 3%; justify-content: center; padding: 40px 80px 30px 115px;">
                    <!-- Course Name -->
                    <div>
                      <label class="text" style="position: relative; top: 24px; display: block; width: 120%;">Course Name</label><br />
                      <div style="padding-top: 13px;">
                        <select class="custom-select-course" id="course" name="course" required>
                          <option value="">Select</option>
                          <?php if ($storedRow): ?>
                            <option value="<?= $storedRow['courseName'] ?>" selected><?= $storedRow['courseName'] ?></option>
                          <?php endif; ?>
                        </select>
                      </div>
                    </div>

                    <!-- Batch -->
                    <div class="col-sm-1" id="col0">
                      <label class="text" style="position: relative; top: 24px;">Batch</label>
                      <select class="custom-select-batch" id="batchno" name="batch" required>
                        <option value="">Select</option>
                        <?php if ($storedRow): ?>
                          <option value="<?= $storedRow['batch'] ?>" selected><?= $storedRow['batch'] ?></option>
                        <?php endif; ?>
                      </select>
                    </div>

                    <!-- Start Date -->
                    <div style="padding-left: 10px;">
                      <label class="text" style="position: relative; top: 21px; width: 120%; display: block;">Form Start Date</label>
                      <div>
                        <input class="custom-select-date" type="date" name="startDate" required
                          style="position: relative; top: 34px; padding: 0px 6px 0px 14px; left: -7px; width: 115%;" />
                      </div>
                    </div>

                    <!-- End Date -->
                    <div style="padding-left: 40px;">
                      <label class="text" style="position: relative; top: 21px; width: 110%; display: block;">Form End Date</label>
                      <div>
                        <input class="custom-select-date" type="date" name="endDate" required
                          style="position: relative; top: 33px; padding: 0px 6px 0px 14px; left: -4%; width: 100%;" />
                      </div>
                    </div>

                    <!-- Monthly Fee -->
                    <div style="position: relative; left: 10px;">
                      <label class="text" style="position: relative; top: 20px; left: 4px;">Monthly Fee</label>
                      <input class="custom-select-fee" type="number" name="monthlyFee" placeholder="XXXXX" required
                        style="position: relative; top: 32px; width: 100%; left: 3px;" />
                    </div>

                    <!-- Total Fee -->
                    <div style="position: relative; left: 14px; top: 31px;">
                      <label class="text" style="position: relative; top: -10px;">Total Fee</label>
                      <input class="custom-select-total-fee" type="number" name="totalFee" placeholder="XXXXX" required
                        style="width: 100%;" />
                    </div>
                  </div>

                  <!-- Discounts & Voucher Dates -->
                  <div style="display: flex; gap: 3%; justify-content: center; padding: 40px 80px 30px 115px;">
                    <div>
                      <label class="text" style="position: relative; top: -10px;">Discount</label>
                      <input class="custom-select-total-fee" type="number" name="discount" min="0" max="100" placeholder="XX" style="width: 90%;" />
                    </div>
                    <div>
                      <label class="text" style="position: relative; top: -10px;">Student Discount</label>
                      <input class="custom-select-total-fee" type="number" name="studentDiscount" min="0" max="100" placeholder="XX" style="width: 100%; position: relative; top: -1px;" />
                    </div>
                    <div>
                      <label class="text" style="position: relative; top: -10px;">Professional Discount</label>
                      <input class="custom-select-total-fee" type="number" name="professionalDiscount" min="0" max="100" placeholder="XX" style="width: 100%; position: relative; top: -2px;" />
                    </div>
                    <div>
                      <label class="text" style="position: relative; top: -11px;">Fee Voucher Start Date</label>
                      <input class="custom-select-show-date" type="date" name="showDateFrom" required style="width: 96%; position: relative; top: -4px;" />
                    </div>
                    <div>
                      <label class="text" style="position: relative; top: -11px;">Fee Voucher End Date</label>
                      <input class="custom-select-show-date" type="date" name="showDateTo" required style="width: 100%; position: relative; top: -5px;" />
                    </div>
                  </div>

                  <!-- Submit Button -->
                  <div style="display: flex; justify-content: center; padding-bottom: 50px; padding-top: 20px;">
                    <input type="submit" value="ADD ROW" name="submitFee"
                      style="background-color: rgb(161, 1, 1); padding: 15px 65px; border-radius: 26px; border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer;" />
                  </div>
                </div>
              </div>
            </form>

            <!-- Fee Table -->
            <?php if (!empty($feeData)): ?>
            <div style="padding-bottom: 40px; padding-left: 110px; padding-right: 58px;">
              <table>
                <thead>
                  <tr style="background-color: #a10101; color: white;">
                    <th>#</th>
                    <th>Course Name</th>
                    <th>Batch</th>
                    <th>Form Start Date</th>
                    <th>Form End Date</th>
                    <th>Monthly Fee</th>
                    <th>Total Fee</th>
                    <th>Discount</th>
                    <th>Student Discount</th>
                    <th>Professional Discount</th>
                    <th>Fee Voucher Start Date</th>
                    <th>Fee Voucher End Date</th>
                  </tr>
                </thead>
                <tbody>
                  <!-- Repeat rows dynamically -->
                  <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                    <td>1</td>
                    <td><?= htmlspecialchars($feeData['course']) ?></td>
                    <td><?= htmlspecialchars($feeData['batch']) ?></td>
                    <td><?= htmlspecialchars($feeData['startDate']) ?></td>
                    <td><?= htmlspecialchars($feeData['endDate']) ?></td>
                    <td><?= htmlspecialchars($feeData['monthlyFee']) ?></td>
                    <td><?= htmlspecialchars($feeData['totalFee']) ?></td>
                    <td><?= htmlspecialchars($feeData['discount']) ?></td>
                    <td><?= htmlspecialchars($feeData['studentDiscount']) ?></td>
                    <td><?= htmlspecialchars($feeData['professionalDiscount']) ?></td>
                    <td><?= htmlspecialchars($feeData['showDateFrom']) ?></td>
                    <td><?= htmlspecialchars($feeData['showDateTo']) ?></td>
                    <td style="background: none; border: none;"><button class="update-btn">UPDATE</button></td>
                  </tr>
                </tbody>
              </table>
            </div>
            <?php endif; ?>
          </div>

          <div class="container5" style="background-color: maroon; height: 80px; margin-top: -16px; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
            <div class="py-2 text-center">
              <p class="text-align-center" style="font-size: 16px; padding-top: 20px;">
                <span style="color: white; font-weight: 600;">
                  © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                </span>
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </body>
</html>