<?php
  session_start();

  // Clear fee_data on page refresh with ?reset=true
  if (isset($_GET['reset']) && $_GET['reset'] === 'true') {
    unset($_SESSION['fee_data']);
    header("Location: AddFeeType.php"); // Clean URL after reset
    exit();
  }

  // Require user to be logged in
  if (!isset($_SESSION['username'])) {
    header("Location: LoginPage.php");
    exit();
  }

  // Check for session hijacking (IP address change)
  if (!isset($_SESSION['user_ip'])) {
    $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
  } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
    session_unset();
    session_destroy();
    header("Location: LoginPage.php");
    exit();
  }

  // Session timeout logic
  $timeout = 600; // 10 minutes
  if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
    session_unset();
    session_destroy();
    header("Location: LoginPage.php");
    exit();
  }
  $_SESSION['last_activity'] = time();

  // ✅ Handle form submission safely
  if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['programme'], $_POST['fee'], $_POST['Abbreviation'])) {
    $new_row = [
      'programme' => $_POST['programme'],
      'fee' => $_POST['fee'],
      'abbreviation' => $_POST['Abbreviation']
    ];

    if (!isset($_SESSION['fee_data'])) {
      $_SESSION['fee_data'] = [];
    }
    $_SESSION['fee_data'][] = $new_row;

    // Set flag to prevent resubmission on refresh
    $_SESSION['form_submitted'] = true;

    // Redirect once (Post/Redirect/Get pattern)
    header("Location: AddFeeType.php");
    exit();
  }

  // ✅ Clear redirect flag after first display
  if (isset($_SESSION['form_submitted'])) {
    unset($_SESSION['form_submitted']);
  }
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
      rel="stylesheet"
    />
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
      rel="stylesheet"
      integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
      crossorigin="anonymous"
    />
    <link rel="stylesheet" href="assets/css/styles.css" />
    <title>NED ACADEMY</title>
  </head>
  <body>
    <div class="form-container">
      <div class="container" style="padding-top: 130px; padding-bottom: 100px">
        <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
          <div class="container1">
            <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
              <div class="py-2 text-left">
                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
              </div>
              <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">ADD FEE TYPE</h2>
              <div style="display: flex; justify-content: flex-end; padding: 10px;">
                <button class="logout-btn" style="background: none; border: none;">
                  <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                    LOGOUT
                  </a>
                </button>
              </div>
              <div style="padding-left: 30px;">
                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                  BACK
                </button>
              </div>
            </div>
          </div>

          <div class="container2">
            <form name="myform" method="POST" action="AddFeeType.php">
              <input type="hidden" id="pagename" name="pagename" value="StudentDiscount">   
              <div style="display: flex; text-align: justify; padding: 50px; gap: 2%;">
                <div style="width: 33.33%;">
                  <label class="text">Programme Name</label><br>
                  <div style="padding-top: 10px">
                    <!-- FIXED ID HERE -->
                    <select class="custom-select-cpt" id="programme" name="programme" required>
                      <option value="">Select</option>
                      <option value="PGD">PGD</option>
                      <option value="UGD">UGD</option>
                    </select>
                  </div>
                </div>

                <div style="width: 33.33%;">
                  <label class="text">Fee Type</label><br>
                  <div style="padding-top: 10px">
                    <input class="custom-select-cpt" id="fee" name="fee" placeholder="Fee Type" required>
                  </div>
                </div>

                <div style="width: 33.33%;">
                  <label class="text">Abbreviation</label><br>
                  <div style="padding-top: 10px">
                    <input class="custom-select-cpt" id="Abbreviation" name="Abbreviation" placeholder="Abbreviation" required>
                  </div>
                </div>
              </div>

              <div style="display: flex; justify-content: center; padding-bottom: 20px; position: relative; top: -10px;">
                <input type="submit" value="ADD ROW"
                  style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
              </div>
            </form>
            <?php if (!empty($_SESSION['fee_data'])): ?>
              <form action="setadmit" method="POST" onsubmit="return validate(this)">
                <input type="hidden" id="programe1" name="programe1" value="Certificate">
                <input type="hidden" id="yearid1" name="yearid1" value="null">
                <input type="hidden" id="title1" name="title1" value="57866">
                <input type="hidden" id="batchno1" name="batchno1" value="null">
                <div style="padding: 50px; padding-top: 0px;">
                  <table>
                    <thead>
                      <tr style="background-color: #a10101; color: white;">
                        <th>Programme Name</th>
                        <th>Fee Type</th>
                        <th>Abbreviation</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach ($_SESSION['fee_data'] as $row): ?>
                        <?php
                          if (!is_array($row) || !isset($row['programme'], $row['fee'], $row['abbreviation'])) {
                            continue; // Skip invalid or null entries
                          }
                        ?>
                        <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                          <td><?php echo htmlspecialchars($row['programme']); ?></td>
                          <td><?php echo htmlspecialchars($row['fee']); ?></td>
                          <td><?php echo htmlspecialchars($row['abbreviation']); ?></td>
                        </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              </form>
            <?php endif; ?>
          </div>

          <!-- Footer -->
          <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
            <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
              <span style="color: white; font-weight: 600; ">
                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
              </span>
            </p>
          </div>
        </div>
    </div>
    <script>
      if (performance.navigation.type === 1) {
        // Page was reloaded
        if (!window.location.href.includes('?reset=true')) {
          window.location.href = window.location.href.split('?')[0] + '?reset=true';
        }
      }
    </script>
  </body>
</html>