<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();

    // Clear session on refresh
    if (isset($_GET['reset']) && $_GET['reset'] === 'true') {
        unset($_SESSION['pgcc_dates']);
        header("Location: AddPGCCDates.php");
        exit();
    }

    // Handle form submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $new_row = [
            'semester' => $_POST['semester'],
            'start_date' => $_POST['startDate'],
            'end_date' => $_POST['endDate'],
            'monthly_fee' => $_POST['courseFee'],
            'program_type' => $_POST['programmeType'],
            'shift' => $_POST['shift'],
            'web_start' => $_POST['websiteStartDate'],
            'web_end' => $_POST['websiteEndDate']
        ];

        if (!isset($_SESSION['pgcc_dates'])) {
            $_SESSION['pgcc_dates'] = [];
        }

        $_SESSION['pgcc_dates'][] = $new_row;

        // Redirect to prevent resubmission
        header("Location: AddPGCCDates.php?submitted=true");
        exit();
    }

    // If redirected after submission, clear session to reset view
    if (isset($_GET['submitted']) && $_GET['submitted'] === 'true') {
        $submitted_data = $_SESSION['pgcc_dates'] ?? [];
        unset($_SESSION['pgcc_dates']);
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <!-- Header -->
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="text-left">
                            <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: 0; font-family: system-ui; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">ADD PGCC DATES</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; font-family: system-ui; position: relative; bottom: 21px; right: 10px;">
                                    LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="window.history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; font-family: system-ui; position: relative; bottom: 60px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Main Content -->
                    <div class="container3" style="background-color: whitesmoke; ">
                        <form method="POST" action="AddPGCCDates.php">
                            <div class="container-fluid">
                                <div align="center">
                                    <div style="display: flex; justify-content: space-between; padding: 40px 85px 30px 100px;">
                                        <!-- Course Name -->
                                        <div>
                                            <label class="text" style="width: 130%; padding-bottom: 5px;">Semester</label><br />
                                            <div >
                                                <input class="custom-select-course" style="width: 130%;" type="text" name="semester" placeholder="Batchname-I-year" required />
                                            </div>
                                        </div>

                                        <!-- Start Date -->
                                        <div style="position: relative; left: -80px;">
                                            <label class="text" style="width: 200%; padding-bottom: 5px;">Programme Start Date</label>
                                            <div >
                                                <input class="custom-select-date" style="width: 210%;" type="date" name="startDate" required/>
                                            </div>
                                        </div>

                                        <!-- End Date -->
                                        <div style="position: relative; left: -31px;">
                                            <label class="text" style="width: 200%; padding-bottom: 5px;">Fee End Date</label>
                                            <div>
                                                <input class="custom-select-date" style="width: 210%;" type="date" name="endDate" required/>
                                            </div>
                                        </div>

                                        <!-- Course Fee -->
                                        <div >
                                            <label class="text" style="width: 125%; padding-bottom: 5px;">Course Fee</label>
                                            <div>
                                                <input class="custom-select-fee" style="width: 120%;" type="number" name="courseFee" placeholder="XXXXX" required/>
                                            </div>    
                                        </div>
                                    </div>

                                    <div style="display: flex; justify-content: space-between; padding: 0px 128px 10px 100px">
                                        <!-- Total Fee -->
                                        <div >
                                            <label class="text" style="width: 200%; padding-bottom: 5px;">Programme Type</label>
                                            <div>
                                                <select class="custom-select-total-fee" style="width: 200%;" type="number" name="programmeType" placeholder="XXXXX" required >
                                                    <option value="">Select</option>
                                                    <option>MS</option>
                                                    <option>M.Engg.</option>
                                                    <option>MEM</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div style="position: relative; left: -57px">
                                            <label class="text" style="width: 360%; padding-bottom: 5px;">Shift</label>
                                            <div>
                                                <select class="custom-select-total-fee" style="width: 344%;" type="number" name="shift" placeholder="XXXXX" required >
                                                    <option value="">Select</option>
                                                    <option>Evening</option>
                                                    <option>Weekend</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div style="position: relative; left: 11px;">
                                            <label class="text" style="width: 210%; padding-bottom: 5px;">Website Start Date</label>
                                            <div>
                                                <input class="custom-select-date" style="width: 210%;" type="date" name="websiteStartDate" required/>
                                            </div>
                                        </div>

                                        <!-- End Date -->
                                        <div >
                                            <label class="text" style="width: 160%; padding-bottom: 5px;">Website End Date</label>
                                            <div>
                                                <input class="custom-select-date" style="width: 153%;" type="date" name="websiteEndDate" required />
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Submit Button -->
                                    <div style="display: flex; justify-content: center; padding-bottom: 40px; padding-top: 40px;">
                                        <input type="submit" value="ADD ROW"
                                        style="background-color: rgb(161, 1, 1); padding: 15px 65px; border-radius: 26px; border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer;" />
                                    </div>
                                </div>
                            </div>
                        </form>

                        <!-- Fee Table -->
                        <?php if (isset($submitted_data) && !empty($submitted_data)): ?>
                            <div style="padding-bottom: 40px; padding-left: 110px; padding-right: 58px;">
                                <table>
                                    <thead>
                                        <tr style="background-color: #a10101; color: white;">
                                            <th>#</th>
                                            <th>Semester</th>
                                            <th>Programme Start Date</th>
                                            <th>Fee End Date</th>
                                            <th>Course Fee</th>
                                            <th>Programme Type</th>
                                            <th>Shift</th>
                                            <th>Website Start Date</th>
                                            <th>Website End Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($submitted_data as $index => $row): ?>
                                            <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                                <td><?= $index + 1 ?></td>
                                                <td contenteditable="true"><?= htmlspecialchars($row['semester']) ?></td>
                                                <td contenteditable="true"><?= htmlspecialchars($row['start_date']) ?></td>
                                                <td contenteditable="true"><?= htmlspecialchars($row['end_date']) ?></td>
                                                <td contenteditable="true"><?= htmlspecialchars($row['monthly_fee']) ?></td>
                                                <td contenteditable="true"><?= htmlspecialchars($row['program_type']) ?></td>
                                                <td contenteditable="true"><?= htmlspecialchars($row['shift']) ?></td>
                                                <td contenteditable="true"><?= htmlspecialchars($row['web_start']) ?></td>
                                                <td contenteditable="true"><?= htmlspecialchars($row['web_end']) ?></td>
                                                <td style="background: none; border: none"><button class="update-btn">UPDATE</button></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Footer -->
                    <div class="container4" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                            © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <script>
            if (performance.navigation.type === 1) {
                // Full page reload
                window.location.href = "AddPGCCDates.php?reset=true";
            }
        </script>
    </body>
</html>