<?php
    session_start();

    if (isset($_GET['submitted']) && $_GET['submitted'] === 'true') {
        $_SESSION['just_submitted'] = true;  // Set flag
        header("Location: AddPaidTo.php");   // Clean URL
        exit();
    }

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes

    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();

    if (isset($_SESSION['just_submitted'])) {
        // Show table once, then clean on next refresh
        $show_table = true;
        unset($_SESSION['just_submitted']);
    } else {
        $show_table = false;
    }

    // Handle submitted form
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['phead'], $_POST['pcnic'])) {
        $new_row = [
            'phead' => $_POST['phead'],
            'pcnic' => $_POST['pcnic'],
            'pntn' => $_POST['pntn'],
            'pbname' => $_POST['pbname'],
            'pacount' => $_POST['pacount'],
            'pcategory' => $_POST['pcategory'],
            'spcategory' => $_POST['spcategory'],
            'ppers' => $_POST['ppers']
        ];

        if (!isset($_SESSION['paid_to_data'])) {
            $_SESSION['paid_to_data'] = [];
        }

        $_SESSION['paid_to_data'][] = $new_row;
        $_SESSION['paid_to_submitted'] = true;

        // PRG pattern
        header("Location: AddPaidTo.php?submitted=true");
        exit();
    }

    if (isset($_GET['submitted']) && $_GET['submitted'] === 'true') {
        unset($_SESSION['paid_to_data']);
        header("Location: AddPaidTo.php");
        exit();
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">ADD PAID TO HEADS</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <form method="POST" action="AddPaidTo.php">
                            <div style="display: flex; gap: 1%; margin-left: 50px; margin-right: 50px; padding-top: 30px;">
                                <div>
                                    <label class='text' style="padding-bottom: 10px">Category</label>
                                    <select id="pcategory" name="pcategory" onkeypress="clearBox();" class="custom-select" required="" onchange="return jsFunction(this);">
                                        <option value="0">Select</option>
                                        <option value="Internal" >Internal</option>
                                        <option value="Internee">Internee</option>
                                        <option value="Director CCEE">Director CCEE</option>
                                        <option value="External">External</option>
                                    </select>
                                </div>
                                <div id="subid" >
                                    <label class='text' style="padding-bottom: 10px">Sub Category</label>
                                    <select id="spcategory" name="spcategory" onkeypress="clearBox();" class="custom-select" required="">
                                        <option value="0">Select</option>
                                        <option value="Teaching">Teaching</option>
                                        <option value="NonTeaching">Non-Teaching</option> 
                                    </select>
                                </div>
                                <div id="pname">
                                    <label class='text' style="padding-bottom: 10px">Paid To</label>
                                    <input class="custom-select" type="text" placeholder="Paid To" name="phead" id="phead"  oninput="this.value = this.value.toUpperCase();">
                                </div>    
                                <div id="pers" >
                                    <label class='text' style="padding-bottom: 10px">Pers #</label>
                                    <input class="custom-select" type="text" placeholder="XXXXXXXXXXXX" name="ppers" id="ppers" >
                                </div>
                                <div id="cnic">
                                    <label class='text' style="padding-bottom: 10px">CNIC #</label>
                                    <input class="custom-select" type="text" placeholder="XXXXXXXXXXXX" name="pcnic" id="pcnic" >
                                </div>
                                <div id="ntn" >
                                    <label class='text' style="padding-bottom: 10px">NTN #</label>
                                    <input class="custom-select" type="text" placeholder="XXXXXXXXXXXX" name="pntn" id="pntn" >
                                </div>
                                <div id="bname" >
                                    <label class='text' style="padding-bottom: 10px">BankName</label>
                                    <input class="custom-select" type="text" placeholder="XXXXXXXXXXXX" name="pbname" id="pbname"  oninput="this.value = this.value.toUpperCase();">
                                </div>
                                <div id="accno" >
                                    <label class='text' style="padding-bottom: 10px">Account #</label>
                                    <input class="custom-select" type="text" placeholder="XXXXXXXXXXXX" name="pacount" id="pacount" >
                                </div>
                            </div>
                            <div style="text-align: center; padding-top: 40px; padding-bottom: 10px;">
                                <input type="submit" value="ADD ROW"
                                style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                            </div>
                        </form>
                        <?php if (!empty($_SESSION['paid_to_data']) && $show_table): ?>
                            <form action="setadmit" method="POST" onsubmit="return validate(this)">
                                <input type="hidden" name="programe1" value="Certificate">
                                <input type="hidden" name="yearid1" value="null">
                                <input type="hidden" name="title1" value="57866">
                                <input type="hidden" name="batchno1" value="null">

                                <div style="padding: 50px; padding-top: 0px;">
                                <table>
                                    <thead>
                                    <tr style="background-color: #a10101; color: white;">
                                        <th>Paid To</th>
                                        <th>CNIC #</th>
                                        <th>NTN #</th>
                                        <th>BankName</th>
                                        <th>Account #</th>
                                        <th>Category</th>
                                        <th>Sub Category</th>
                                        <th>Pers #</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($_SESSION['paid_to_data'] as $row): ?>
                                        <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                        <td contenteditable="true"><?php echo htmlspecialchars($row['phead']); ?></td>
                                        <td contenteditable="true"><?php echo htmlspecialchars($row['pcnic']); ?></td>
                                        <td contenteditable="true"><?php echo htmlspecialchars($row['pntn']); ?></td>
                                        <td contenteditable="true"><?php echo htmlspecialchars($row['pbname']); ?></td>
                                        <td contenteditable="true"><?php echo htmlspecialchars($row['pacount']); ?></td>
                                        <td contenteditable="true"><?php echo htmlspecialchars($row['pcategory']); ?></td>
                                        <td contenteditable="true"><?php echo htmlspecialchars($row['spcategory']); ?></td>
                                        <td contenteditable="true"><?php echo htmlspecialchars($row['ppers']); ?></td>
                                        <td style="background: none; border: none"><button class="update-btn">UPDATE</button></td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                                </div>
                            </form>
                        <?php endif; ?>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>