<?php
  session_start();

  // Require user to be logged in
  if (!isset($_SESSION['username'])) {
      header("Location: LoginPage.php");
      exit();
  }

  // Check for session hijacking (IP address change)
  if (!isset($_SESSION['user_ip'])) {
      $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
  } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
      session_unset();
      session_destroy();
      header("Location: LoginPage.php");
      exit();
  }

  // Session timeout logic
  $timeout = 600; // 10 minutes
  if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
      session_unset();
      session_destroy();
      header("Location: LoginPage.php");
      exit();
  }
  $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">ADMITTED STUDENT LIST FOR PGD</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <form name="myform" method="POST" action="searchvalues">
                            <input type="hidden" id="pagename" name="pagename" value="StudentDiscount">   
                            <div style="display: flex; text-align: justify; padding: 50px; gap: 2%;">
                                <div style="width: 33.33%;">
                                    <label class="text">Programme Name</label><br>
                                    <div style="padding-top: 10px">
                                        <!-- FIXED ID HERE -->
                                        <select class="custom-select-cpt" id="programme" name="programme" required>
                                            <option value="">Select</option>
                                            <option value="PGD">PGD</option>
                                            <option value="UGD">UGD</option>
                                        </select>

                                        <!-- JavaScript inside or below form -->
                                        <script>
                                            document.getElementById('programme').addEventListener('change', function () {
                                                if (this.value === 'UGD') {
                                                    window.location.href = 'AdmittedStudentListUGD.php';
                                                }
                                            });
                                        </script>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                    <label class="text">Course Name</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-cpt" id="courseName" name="courseName" required>
                                            <option>Select</option>
                                            <option>PGD In Devops</option>
                                            <option>PGD In Industrial Safety And Environmental Engineering</option> 
                                            <option>PGD In Islamic Banking &amp; Finance</option> 
                                            <option>PGD in Accounting And Finance</option> 
                                            <option>PGD in Advanced English Language Teaching</option> 
                                            <option>PGD in Animation And Gaming </option>
                                            <option>PGD in Block Chain Technology </option>
                                            <option>PGD in Business Economics </option>
                                            <option>PGD in Business Leadership </option>
                                            <option>PGD in Business Management </option>
                                            <option>PGD in Chemical Engineering </option>
                                            <option>PGD in Cloud Computing </option>
                                            <option>PGD in Cloud-Based IoT And Edge Computing </option>
                                            <option>PGD in Computational Mathematics  </option>
                                            <option>PGD in Computational Science And Engineering </option>
                                            <option>PGD in Construction Cost Engineering </option>
                                            <option>PGD in Construction Management </option>
                                            <option>PGD in Corpus Linguistics </option>
                                            <option>PGD in Cyber Security </option>
                                            <option>PGD in Data Science With Artificial Intelligence (AI) </option>
                                            <option>PGD in Denim Manufacturing &amp; Merchandising </option>
                                            <option>PGD in Electrical Power Systems </option>
                                            <option>PGD in Energy Management </option>
                                            <option>PGD in Food Processing </option>
                                            <option>PGD in Food Supply Chain Management </option>
                                            <option>PGD in Garment Manufacturing </option>
                                            <option>PGD in Generative AI </option>
                                            <option>PGD in Human Resource Management </option>
                                            <option>PGD in Industrial Chemistry </option>
                                            <option>PGD in Industrial Psychology And Organizational Behaviour </option>
                                            <option>PGD in Industrial Relations And Labor Laws </option>
                                            <option>PGD in Industrial Water Treatment </option>
                                            <option>PGD in Insurance &amp; Risk Management </option>
                                            <option>PGD in Marketing Management </option>
                                            <option>PGD in Mechatronics </option>
                                            <option>PGD in Metaverse User Experience Design </option>
                                            <option>PGD in Mind Sciences And Mind Engineering </option>
                                            <option>PGD in Occupational Health And Safety </option>
                                            <option>PGD in Pharmaceutical Engineering </option>
                                            <option>PGD in Polymer Technology </option>
                                            <option>PGD in Procurement, Contracts &amp; Laws </option>
                                            <option>PGD in Production Management </option>
                                            <option>PGD in Project Management </option>
                                            <option>PGD in Renewable Energy </option>
                                            <option>PGD in Software Engineering </option>
                                            <option>PGD in Supply Chain Management </option>
                                            <option>PGD in Sustainable Engineering </option>
                                            <option>PGD in Textile Management </option>
                                            <option>PGD in Textile Merchandising  
                                            <option>PGD in Total Quality Management </option>
                                        </select>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                    <label class="text">Semester</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-cpt" id="semester" name="semester" required>
                                            <option value="">Select</option>
                                            <!-- Populate with options dynamically -->
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div style="display: flex; justify-content: center; padding-bottom: 20px; position: relative; top: -10px;">
                                <input type="submit" value="VIEW"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                            </div>
                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>