<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">ATTENDANCE REPORT FOR PGD</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <form name="myform" method="POST" action="searchvalues">
                            <input type="hidden" id="pagename" name="pagename" value="StudentDiscount">   
                            <div style="display: flex; text-align: justify; padding: 50px; gap: 2%;">
                                <div style="width: 33.33%;">
                                    <label class="text">Programme Name</label><br>
                                    <div style="padding-top: 10px">
                                        <!-- FIXED ID HERE -->
                                        <select class="custom-select-cpt" id="programme" name="programme" required>
                                            <option value="">Select</option>
                                            <option value="PGD">PGD</option>
                                            <option value="UGD">UGD</option>
                                            <option value="PGCC">PGCC</option>
                                            <option value="Certificate">Certificate</option>
                                        </select>

                                        <!-- JavaScript inside or below form -->
                                        <script>
                                            document.getElementById('programme').addEventListener('change', function () {
                                                if (this.value === 'UGD') {
                                                    window.location.href = 'AttendanceReportForUGD.php';
                                                }
                                            });

                                            document.getElementById('programme').addEventListener('change', function () {
                                                if (this.value === 'PGCC') {
                                                    window.location.href = 'AttendanceReportForPGCC.php';
                                                }
                                            });

                                            document.getElementById('programme').addEventListener('change', function () {
                                                if (this.value === 'Certificate') {
                                                    window.location.href = 'AttendanceReportForCertificate.php';
                                                }
                                            });
                                        </script>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                    <label class="text">Course Name</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-cpt" id="courseName" name="courseName" required>
                                            <option>Select</option>
                                            <option>All</option>
                                            <option>International Trade and Export </option>
                                            <option>Merchandising &amp; Sourcing </option>
                                            <option>Textile Product Development </option>
                                            <option>3D Foundation Using Maya </option>
                                            <option>3D Modeling and Animation  </option>
                                            <option>Accounting and Financial Management </option>
                                            <option>Advance Character Animation </option>
                                            <option>Advanced Analysis of Algorithms </option>
                                            <option>Advanced Blockchain Technology for Enterprises </option>
                                            <option>Advanced Garment Production Processes </option>
                                            <option>Advanced Metaverse Technologies </option>
                                            <option>Advanced Project Management Processes </option>
                                            <option>Advanced Unit Operations </option>
                                            <option>Agile and Lean Manufacturing </option>
                                            <option>Air Pollution &amp; Control </option>
                                            <option>Analytical Chemistry </option>
                                            <option>Apparel and Merchandising Management </option>
                                            <option>Application of Robotics in Mechatronics </option>
                                            <option>Applied Cost Control </option>
                                            <option>Applied Statistics </option>
                                            <option>Approaches and Methods in English language Teaching </option>
                                            <option>Artificial Neural Networks </option>
                                            <option>Asset Development &amp; Animation Techniques </option>
                                            <option>Auditing &amp; Assurance </option>
                                            <option>Big Data Computing </option>
                                            <option>Block Chain </option>
                                            <option>Brand Management &amp; Social Media Marketing </option>
                                            <option>Business &amp; Taxation Laws </option>
                                            <option>Business Communication </option>
                                            <option>Business Intelligence </option>
                                            <option>Chemical Engineering Thermodynamics </option>
                                            <option>Claims &amp; Disputes </option>
                                            <option>Cloud Application Security </option>
                                            <option>Cloud Computing </option>
                                            <option>Cloud Computing Concepts and Design </option>
                                            <option>Cloud Computing Data Security </option>
                                            <option>Cloud Computing Operations  </option>
                                            <option>Cloud Computing and Devops </option>
                                            <option>Cloud Platform and Infrastructure Security </option>
                                            <option>Commercial Property and Business Interruption Insurance </option>
                                            <option>Communication Skills for English Language Teachers </option>
                                            <option>Composite and Post Effects </option>
                                            <option>Computational Chemistry and Biology </option>
                                            <option>Computational Linear Algebra </option>
                                            <option>Computational Physics and Engineering </option>
                                            <option>Computer Aided Construction Project Management Using Primavera &amp; Building Information Modeling </option>
                                            <option>Computer Aided Pattern Design and Product Development </option>
                                            <option>Computer Aided Power System Analysis </option>
                                            <option>Construction Finance, Quality and Safety Management  </option>
                                            <option>Construction Informatics and Cost Estimatation </option>
                                            <option>Construction Materials, Technology and Processes </option>
                                            <option>Construction Project Management Framework &amp; Implementation  </option>
                                            <option>Continuous Integration and Continuous Delivery </option>
                                            <option>Contract Management </option>
                                            <option>Corporate Governance </option>
                                            <option>Cost Accounting and Financial Management  </option>
                                            <option>Cost Engineering and Analysis </option>
                                            <option>Cryptography for Blockchain </option>
                                            <option>Cyber Security (Core) </option>
                                            <option>Cyber Security (Defensive) </option>
                                            <option>Cyber Security (Foundation) </option>
                                            <option>Cyber Security (Offensive)  </option>
                                            <option>DApps Development using Web 3.0 </option>
                                            <option>Data Analytics &amp; Data Visualization </option>
                                            <option>Data Analytics and Visualization </option>
                                            <option>Data Visualization </option>
                                            <option>Database Designing and Development </option>
                                            <option>Deep Learning </option>
                                            <option>Denim Manufacturing Processes </option>
                                            <option>Denim Product Development &amp; Design </option>
                                            <option>Desalination Techniques </option>
                                            <option>Desalination and Reverse Osmosis Technology </option>
                                            <option>Design Principles for Metaverse </option>
                                            <option>Designing of Wind &amp; Solar Power Plants with Electrical Infrastructure </option>
                                            <option>Differential Equations </option>
                                            <option>Digital Forensics </option>
                                            <option>Economic Development </option>
                                            <option>Economic Policies of Governments </option>
                                            <option>Edge Computing </option>
                                            <option>Emerging Technologies for Food Processing </option>
                                            <option>Employment Laws </option>
                                            <option>Energy Audits </option>
                                            <option>Energy Conservation </option>
                                            <option>Energy Management </option>
                                            <option>Energy Planning </option>
                                            <option>Energy Storage Systems &amp; Control </option>
                                            <option>Engineering Insurance  </option>
                                            <option>Ensuring World Class Safety Management </option>
                                            <option>Environmental Chemistry </option>
                                            <option>Ethical Hacking </option>
                                            <option>Financial Accounting  </option>
                                            <option>Financial Management </option>
                                            <option>Financial Reporting </option>
                                            <option>Food Quality &amp; Safety Aspects of Food Supply Chain </option>
                                            <option>Food Supply Chain Risk Management </option>
                                            <option>Front End Designing </option>
                                            <option>Functional Foods </option>
                                            <option>Fundamentals of Polymer Science &amp; Technology </option>
                                            <option>Fundamentals of Sustainable Engineering </option>
                                            <option>Garment Manufacturing Fundamentals </option>
                                            <option>Garment Quality Management </option>
                                            <option>Generative AI Foundations on Amazon Web Services </option>
                                            <option>Generative AI in Cloud Computing </option>
                                            <option>Generative AI to Data Science </option>
                                            <option>Generative Models for Computer Vision </option>
                                            <option>HR Best Practices towards Sustaining Industrial Growth </option>
                                            <option>Hazard Recognition &amp; Risk Mitigation Strategies </option>
                                            <option>Health &amp; Safety Foundation </option>
                                            <option>Health and Safety Laws </option>
                                            <option>High Performance and Parallel Computing </option>
                                            <option>Human Resource Management </option>
                                            <option>Human-Machine Interface </option>
                                            <option>Hypnosis </option>
                                            <option>IOT Principles and Design </option>
                                            <option>ISO Quality Certification and Audit Management </option>
                                            <option>Industrial Analytics </option>
                                            <option>Industrial Marketing </option>
                                            <option>Industrial Relations </option>
                                            <option>Industrial Stoichiometry </option>
                                            <option>Industry 4.0 for Engineers </option>
                                            <option>Information Risk Management </option>
                                            <option>Infrastructure as Code (Iac) </option>
                                            <option>Insurance Business and Finance </option>
                                            <option>Integration of Renewable Energy Technologies with Conventional Power System </option>
                                            <option>Intelligence &amp; Behavioural Change </option>
                                            <option>International &amp; Best Value Procurement </option>
                                            <option>Introduction to DevOps </option>
                                            <option>Introduction to Generative AI </option>
                                            <option>Introduction to Industrial Physcology and Organizational Behaviour </option>
                                            <option>Introduction to Large Language Models </option>
                                            <option>Introduction to Metaverse design </option>
                                            <option>Introduction to Mind Science &amp; Mind Engineering </option>
                                            <option>Introduction to Production Management </option>
                                            <option>Inventory Management </option>
                                            <option>IoT &amp; Edge Computing Security </option>
                                            <option>IoT Edge Computing Protocols </option>
                                            <option>Islamic Banking &amp; Finance Fundamentals </option>
                                            <option>Kinetics of Reaction and Reactor Design </option>
                                            <option>Knowledge Based Systems </option>
                                            <option>Language Testing and Assessment </option>
                                            <option>Leadership &amp; Motivation </option>
                                            <option>Leadership in Commercial Organizations </option>
                                            <option>Lean Six Sigma </option>
                                            <option>Legal and Compliance </option>
                                            <option>Logistics, Transportation and Distribution Management </option>
                                            <option>Machine Learning </option>
                                            <option>Macroeconomics </option>
                                            <option>Managerial Economics </option>
                                            <option>Mechatronic Instrumentation &amp; Control </option>
                                            <option>Mechatronics and Industrial Automation </option>
                                            <option>Membrane Filtration </option>
                                            <option>Metaverse Security </option>
                                            <option>Microeconomics </option>
                                            <option>Monitoring and Logging </option>
                                            <option>NLP </option>
                                            <option>NLP Techniques </option>
                                            <option>Number Theory </option>
                                            <option>Numerical Computing </option>
                                            <option>Numerical methods and Algorithm </option>
                                            <option>Optimization Techniques </option>
                                            <option>Organizational Systems </option>
                                            <option>Organizational Improvement and Sustaining Industrial Growth </option>
                                            <option>Organizational Management </option>
                                            <option>Organizational Systems </option>
                                            <option>Performance Appraisal &amp; Compensation Management </option>
                                            <option>Performance Excellence  </option>
                                            <option>Pharma 4.0 </option>
                                            <option>Pharmaceutical Unit Operations </option>
                                            <option>Plant, Operation, Maintenance &amp; Safety </option>
                                            <option>Polymer Morphology-Property Relationships </option>
                                            <option>Polymer Processing </option>
                                            <option>Polymer Rheology </option>
                                            <option>Polymeric Materials and Characterization </option>
                                            <option>Power System Operations </option>
                                            <option>Power System Protection </option>
                                            <option>Power System Stability </option>
                                            <option>Practical Implementation of Islamic Banking </option>
                                            <option>Predictive HR Analytics </option>
                                            <option>Pricing &amp; Emissions Electricity </option>
                                            <option>Pricing And Bidding Strategies </option>
                                            <option>Principles of Chemical Engineering </option>
                                            <option>Principles of Food Supply Chain Management  </option>
                                            <option>Principles of Management </option>
                                            <option>Principles of Marketing </option>
                                            <option>Principles of Pharmaceutical Engineering </option>
                                            <option>Principles of Risk Management and Insurance   </option>
                                            <option>Process Safety Management </option>
                                            <option> Process Safety and Waste Management </option>
                                            <option>Process Utility Calculation </option>
                                            <option>Procurement Management </option>
                                            <option>Procurement and Contracts Management </option>
                                            <option>Products in Islamic Finance </option>
                                            <option>Project Evaluation and Feasibility Analysis </option>
                                            <option>Project Leadership and Governance </option>
                                            <option>Project Management Framework and Environment </option>
                                            <option>Project Management Framework and Tools </option>
                                            <option>Project Management Processes </option>
                                            <option>Project Management Tools (Primavera and Agile) </option>
                                            <option>Python Programming </option>
                                            <option>Python for Blockchain </option>
                                            <option>Python for Data Science </option>
                                            <option>Reactive Power Control </option>
                                            <option>Reinsurance Principles and Practices </option>
                                            <option>Reliability Engineering </option>
                                            <option>Render Techniques Using Unreal </option>
                                            <option>Renewable Energy Systems &amp; Environment </option>
                                            <option>Role of GMP &amp; GAP in Food Supply Chain </option>
                                            <option>Safety &amp; Emergency Management  </option>
                                            <option>Safety Leadership, Culture &amp; Communication  </option>
                                            <option>Safety and Quality in the Food Processing </option>
                                            <option>Scalability and Sustaining the Industrial Growth   </option>
                                            <option>Scientific Computing </option>
                                            <option>Scientific Computing Using Python  </option>
                                            <option>Sensing &amp; Actuating in Mechatronics </option>
                                            <option>Sewn Product Engineering </option>
                                            <option>Smart Contracts¿Development &amp; Deployment for Blockchain Backend </option>
                                            <option>Software Development (Foundation) </option>
                                            <option>Special Topics in Cost Engineering </option>
                                            <option>Strategic Human Resource Management </option>
                                            <option>Strategic Islamic Financing </option>
                                            <option>Strategic Planning and Decision Making </option>
                                            <option>Super Mind Programing  </option>
                                            <option>Supply Chain Design and Management </option>
                                            <option>Supply Chain Management </option>
                                            <option>Sustainability - Economics, Tools, Management </option>
                                            <option>Sustainable Waste Management </option>
                                            <option>Syllabus Design and Curriculum Development in ELT </option>
                                            <option>Textile Brand Management and Marketing </option>
                                            <option>Textile Sustainability and Future Trends </option>
                                            <option>Time Series Analysis </option>
                                            <option>Tools and Techniques for Data Science </option>
                                            <option>Total Quality Management </option>
                                            <option>Treasury &amp; Risk Management </option>
                                            <option>Unit Operations and Reaction Kinetics </option>
                                            <option>Water Purification Processes </option>
                                            <option>Water Treatment Techniques </option>
                                            <option>Web 3.0 </option>
                                            <option>Web Development Via PhP </option>
                                            <option>Welfare Laws </option>
                                            <option>World Englishes and Technology in Language </option>
                                        </select>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                    <label class="text">Semester</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-cpt" id="semester" name="semester" required>
                                            <option value="">Select</option>
                                            <!-- Populate with options dynamically -->
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div style="display: flex; justify-content: center; gap: 1%; padding-bottom: 10px; padding-top: 10px;">
                                <div>
                                <input type="submit" value="VIEW"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                                </div>
                            </div>
                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>