<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">ATTENDANCE REPORT FOR PGCC</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <form name="myform" method="POST" action="searchvalues">
                            <input type="hidden" id="pagename" name="pagename" value="StudentDiscount">   
                            <div style="display: flex; text-align: justify; padding: 50px; gap: 2%;">
                                <div style="width: 33.33%;">
                                    <label class="text">Programme Name</label><br>
                                    <div style="padding-top: 10px">
                                        <!-- FIXED ID HERE -->
                                        <select class="custom-select-cpt" id="programme" name="programme" required>
                                            <option value="">Select</option>
                                            <option value="PGD">PGD</option>
                                            <option value="UGD">UGD</option>
                                            <option value="PGCC">PGCC</option>
                                            <option value="Certificate">Certificate</option>
                                        </select>

                                        <!-- JavaScript inside or below form -->
                                        <script>
                                            document.getElementById('programme').addEventListener('change', function () {
                                                if (this.value === 'PGD') {
                                                    window.location.href = 'AttendanceReport.php';
                                                }
                                            });

                                            document.getElementById('programme').addEventListener('change', function () {
                                                if (this.value === 'UGD') {
                                                    window.location.href = 'AttendanceReportForUGD.php';
                                                }
                                            });

                                            document.getElementById('programme').addEventListener('change', function () {
                                                if (this.value === 'Certificate') {
                                                    window.location.href = 'AttendanceReportForCertificate.php';
                                                }
                                            });
                                        </script>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                    <label class="text">Course Name</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-cpt" id="courseName" name="courseName" required>
                                            <option>Select</option>
                                            <option>All</option>
                                            <option>3D Animation </option>
                                            <option>3D Animation with Blender </option>
                                            <option>3D Modeling with Blender </option>
                                            <option>AUTOCAD for Interior Design </option>
                                            <option>Administration in Cloud Services </option>
                                            <option>Advance Web Programming Via PHP </option>
                                            <option>Analytics with Google Analytics &amp; Search Engine Optimisation (SEO) </option>
                                            <option>Application Security </option>
                                            <option>Automotive Chassis Systems </option>
                                            <option>Automotive Electrical and Electronics </option>
                                            <option>Automotive Engines </option>
                                            <option>Automotive HVAC Safety and Convenience Systems </option>
                                            <option>Automotive Transmission and Drives </option>
                                            <option>Auxiliary Systems for R&amp;AC applications </option>
                                            <option>Basic Drawing &amp; Illustration </option>
                                            <option>Basics of AI and its Applications  </option>
                                            <option>Business Intelligence </option>
                                            <option>Calculus and Linear Algebra </option>
                                            <option>Components for R&amp;AC applications </option>
                                            <option>Computer Networks 
                                            <option>Computer Programming (PYTHON) 
                                            <option>Content Marketing and Advertising 
                                            <option>Cybersecurity Governance and Compliance 
                                            <option>Data Analysis and Visualization 
                                            <option>Data Collection and Preprocessing 
                                            <option>Data Engineering Foundations: Modern Data Warehouse &amp; Data Lake 
                                            <option>Data Manipulation Using Libraries 
                                            <option>Data Modeling 
                                            <option>Database Management System (DBMS) 
                                            <option>Design Pattern of Data Pipeline 
                                            <option>Design Tools &amp; Softwares 
                                            <option>Digital Marketing 
                                            <option>Digital Marketing Strategy Designing 
                                            <option>Digital Marketing Using AI 
                                            <option>Drafting and Scaled Drawing for Interior Design 
                                            <option>Electrical Circuits and Instrumentation 
                                            <option>Electrical Machines: Design, Operation and Maintenance 
                                            <option>Electrical Power System Protection 
                                            <option>Email Marketing &amp; Paid Search (PPC) using Google Ads 
                                            <option>Fabric Preparatory Processes 
                                            <option>Fashion Portfolio 
                                            <option>Fundamentals of Air Conditioning Systems and Psychrometry 
                                            <option>Fundamentals of Refrigeration and Selection of Refrigeration 
                                            <option>Game Modelling by Unity 2D &amp; 3D, Illustrator 
                                            <option>Garment Manufacturing  
                                            <option>Generative AI Foundations on Amazon Web Services (AWS) 
                                            <option>Generative AI in Cloud Computing 
                                            <option>Generative Models and Machine Leaning 
                                            <option>Graphic Design Advance 
                                            <option>Graphic Design Base 
                                            <option>Graphics Designing  
                                            <option>Heat load Estimation for Air Conditioning and Refrigeration Applications 
                                            <option>Interior Design Fundamentals 
                                            <option>Interior Design Studio 
                                            <option>Interior Sketching &amp; Perspective Drawing 
                                            <option>Introduction to Basics &amp; Office Automation  
                                            <option>Introduction to Computer Networks 
                                            <option>Introduction to Cybersecurity 
                                            <option>Introduction to Fashion &amp; Textiles 
                                            <option>Introduction to Gaming Industry, Game Programming &amp; Game Designing  
                                            <option>Introduction to Generative AI 
                                            <option>Introduction to Large Language Models 
                                            <option>Introduction to NLP 
                                            <option>Introduction to Physics in Game Development 
                                            <option>Introduction to Textiles 
                                            <option>Machine Learning and its Applications 
                                            <option>Materials &amp; Print Design 
                                            <option>Modeling and Animation  
                                            <option>Motion Graphics &amp; Video Editing 
                                            <option>Motion Graphics and Video Editing 
                                            <option>Network Configuration and Management 
                                            <option>Network Design and Implementation 
                                            <option>Network Security 
                                            <option>Object Oriented Programming (PYTHON) 
                                            <option>Object Oriented Programming (Python) AND Data Visualization 
                                            <option>Occupational Safety &amp; Health 
                                            <option>On-Premise and Cloud base Data engineering tool 
                                            <option>Operating System  
                                            <option>Photography 
                                            <option>Portfolio Development and Freelance design Workflow 
                                            <option>Post-Production  
                                            <option>Power Generation, Transmission and Distribution 
                                            <option>Power System Analysis 
                                            <option>Pre-Treatment &amp; Dyeing  
                                            <option>Principles of Design &amp; Pattern Making 
                                            <option>Programming with Data Structures 
                                            <option>Python Programming for Generative AI 
                                            <option>Python for AI 
                                            <option>Python for Data Science 
                                            <option>SQL &amp; Python for Data Engineering 
                                            <option>SQL and databases 
                                            <option>Security Operation Center and Incident Response 
                                            <option>Selection of Air conditioning Systems 
                                            <option>Server Administration and Virtualization 
                                            <option>Sketchup for Interior Design 
                                            <option>Software Engineering Principals 
                                            <option>System Administration and Server Management 
                                            <option>System Security 
                                            <option>Textile Brand Management and Marketing 
                                            <option>Textile Printing &amp; Finishing  
                                            <option>UI/UX Designing 
                                            <option>Unreal Engine 
                                            <option>Vehicle Maintenance and Service 
                                            <option>Video Editing and Animations 
                                            <option>Web Design and Development 
                                            <option>Web Designing (Front End Development) 
                                            <option>Web Designing and Website Optimisation 
                                        </select>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                    <label class="text">Semester</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-cpt" id="semester" name="semester" required>
                                            <option value="">Select</option>
                                            <!-- Populate with options dynamically -->
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div style="display: flex; justify-content: center; gap: 1%; padding-bottom: 10px; padding-top: 10px;">
                                <div>
                                <input type="submit" value="VIEW"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                                </div>
                            </div>
                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>