<?php
    session_start();

    // Reset session data if user refreshes or manually triggers reset
    if (isset($_GET['reset']) && $_GET['reset'] === 'true') {
        unset($_SESSION['budget_data']);
        header("Location: " . strtok($_SERVER["REQUEST_URI"], '?')); // Clean redirect
        exit();
    }

    // Handle form submission (ADD ROW)
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_row'])) {
        $ahead = $_POST['ahead'] ?? '';
        $acode = $_POST['acode'] ?? '';
        $date_from = $_POST['date_from'] ?? '';
        $date_to = $_POST['date_to'] ?? '';

        $_SESSION['budget_data'] = [
            'ahead' => $ahead,
            'acode' => $acode,
            'date_from' => $date_from,
            'date_to' => $date_to,
        ];

        // Redirect to avoid resubmission
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">SET BUDGET ALLOCATIONS</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <form name="myform" method="POST" action="">
                            <input type="hidden" id="pagename" name="pagename" value="StudentDiscount"> 
                            <div style="display: flex; text-align: justify; padding: 50px; gap: 2%;">
                                <div style="width: 40%;" >
                                    <label class="text">Head of Account</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select" name="ahead" id="ahead" style="width:100.0%;">
                                            <option>Select</option>
                                            <option>Advertisement &amp; Publicity </option>
                                            <option>Certificate Refund </option>
                                            <option>Entertainment </option>
                                            <option>Expected Closing Balance </option>
                                            <option>Expected Investment </option>
                                            <option>Furniture &amp; Fixture </option>
                                            <option>Machinery &amp; Equipment </option>
                                            <option>PGCC Refund </option>
                                            <option>PGD Refund </option>
                                            <option>PITP </option>
                                            <option>Printing &amp; Stationary </option>
                                            <option>Registrar Office Payments </option>
                                            <option>Resource Person </option>
                                            <option>Service Charges </option>
                                            <option>UGD Refund </option>
                                            <option>Unforeseen Expenses </option>
                                        </select>
                                    </div>
                                </div>
                                <div style="width: 20%;">
                                    <label class="text">Allocation</label><br>
                                    <div style="padding-top: 10px">
                                        <input class="custom-select" type="number" placeholder="Account Code" name="acode" id="acode" style="width:100.0%;">
                                    </div>
                                </div>
                                <div style="width: 20%;">
                                    <label class="text">Date From</label><br>
                                    <div style="padding-top: 10px">
                                        <input class="custom-select" type="date" name="date_from" style="width:100.0%;">
                                    </div>
                                </div>
                                <div style="width: 20%;">
                                    <label class="text">Date To</label><br>
                                    <div style="padding-top: 10px">
                                        <input class="custom-select" type="date" name="date_to" style="width:100.0%;">
                                    </div>
                                </div>
                            </div>
                                
                            <div style="display: flex; justify-content: center;"  >
                                <input type="submit" name="submit_row" value="ADD ROW"
                                style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                            </div>
                        </form>
                        <form action="setadmit" method="POST" onsubmit="return validate(this)">
                            <input type="hidden" id="programe1" name="programe1" value="Certificate">
                            <input type="hidden" id="yearid1" name="yearid1" value="null">
                            <input type="hidden" id="title1" name="title1" value="57866">
                            <input type="hidden" id="batchno1" name="batchno1" value="null">
                            <div style="padding-left: 50px; padding-right: 50px;">
                                <table>
                                    <?php if (isset($_SESSION['budget_data'])): ?>
                                    <thead>
                                        <tr style="background-color: #a10101; color: white;">
                                            <th>Head of Account</th>
                                            <th>Allocation</th>
                                            <th>Date From</th>
                                            <th>Date To</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    
                                        <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                            <td><input type="text" name="ahead" value="<?= htmlspecialchars($_SESSION['budget_data']['ahead']) ?>" style="width: 100%; text-align: center;" /></td>
                                            <td><input type="number" name="acode" value="<?= htmlspecialchars($_SESSION['budget_data']['acode']) ?>" style="width: 100%; text-align: center;" /></td>
                                            <td><input type="date" name="date_from" value="<?= htmlspecialchars($_SESSION['budget_data']['date_from']) ?>" style="width: 100%; text-align: center;" /></td>
                                            <td><input type="date" name="date_to" value="<?= htmlspecialchars($_SESSION['budget_data']['date_to']) ?>" style="width: 100%; text-align: center;" /></td>
                                            <td style="background: none; border: none">
                                                <input type="submit" value="UPDATE" style="background-color: rgba(39, 10, 78, 0.973); padding: 10px 27px; border-radius: 70px; border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;">
                                            </td>
                                        </tr>
                                    
                                    </tbody>
                                    <?php endif; ?>
                                </table>
                            </div>
                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <script>
            // Redirect with ?reset=true on hard refresh
            if (performance.navigation.type === 1) {
                window.location.href = window.location.pathname + '?reset=true';
            }
        </script>
    </body>
</html>