<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();

    // Handle redirect after submission
    if (isset($_GET['submitted']) && $_GET['submitted'] === 'true') {
        $_SESSION['just_submitted'] = true;
        header("Location: BudgetHeadCategories.php");
        exit();
    }

    $budgetOptions = [
        "1" => "Machinery & Equipment",
        "2" => "Furniture & Fixture",
        "3" => "Printing & Stationary",
        "4" => "Advertisement & Publicity",
        "5" => "Entertainment",
        "6" => "Unforeseen Expenses",
        "7" => "Resource Person",
        "8" => "Expected Investment",
        "9" => "Expected Closing Balance",
        "10" => "UGD Refund",
        "11" => "PGD Refund",
        "12" => "Certificate Refund",
        "13" => "PGCC Refund",
        "14" => "Registrar Office Payments",
        "15" => "PITP",
        "16" => "Service Charges"
    ];

    // Initial session array if not set
    if (!isset($_SESSION['budget_rows'])) {
        $_SESSION['budget_rows'] = [];
    }

    // On view button click
    if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['submit_row'])) {
        $_SESSION['selected_head'] = $_POST['budget_head'];
    }

    // On update button click
    if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['update_row'])) {
        $code = str_pad(count($_SESSION['budget_rows']) + 1, 3, '0', STR_PAD_LEFT);
        $head = $_POST['budget_heads'];
        $sub = $_POST['sub_category'];

        $_SESSION['budget_rows'][] = [
            'code' => $code,
            'head' => $head,
            'sub'  => $sub
        ];
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">BUDGET HEAD CATEGORIES</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <div class="form-group">
                            <form name="myform" method="POST" action="">
                                <input type="hidden" id="pagename" name="pagename" value="StudentDiscount">   
                                <div style="text-align: justify; padding: 50px;">
                                    <label class="text">Budget Heads</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select" name="budget_head">
                                            <option>Select</option>
                                            <option value="4">Advertisement &amp; Publicity </option>
                                            <option value="12">Certificate Refund </option> 
                                            <option value="5">Entertainment </option>
                                            <option value="9">Expected Closing Balance </option>
                                            <option value="8">Expected Investment </option>
                                            <option value="2">Furniture &amp; Fixture </option>
                                            <option value="1">Machinery &amp; Equipment </option>
                                            <option value="13">PGCC Refund </option>
                                            <option value="11">PGD Refund </option>
                                            <option value="15">PITP </option>
                                            <option value="3">Printing &amp; Stationary </option>
                                            <option value="14">Registrar Office Payments </option>
                                            <option value="7">Resource Person </option>
                                            <option value="16">Service Charges </option>
                                            <option value="10">UGD Refund </option>
                                            <option value="6">Unforeseen Expenses </option>
                                        </select>
                                    </div>
                                </div>
                                <div style="text-align: center; padding-bottom: 20px; position: relative; top: -10px;">
                                    <input type="submit" name="submit_row" value="VIEW"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                                </div>
                            </form>    
                            <?php if (isset($_SESSION['selected_head'])): ?>
                                <form method="POST" action="">
                                    <div style="display: flex; margin-left: 50px; gap: 1%; padding-bottom: 30px">
                                        <div style="width: 28%">
                                            <label class="text" style="padding-bottom: 10px">Code</label><br>
                                            <input type="text" class="custom-select" name="code" value="<?= str_pad(count($_SESSION['budget_rows']) + 1, 3, '0', STR_PAD_LEFT) ?>" readonly>
                                        </div>
                                        <div style="width: 28%">
                                            <label class="text" style="padding-bottom: 10px">Head of Account</label><br>
                                            <input type="text" class="custom-select" name="budget_heads" value="<?= $budgetOptions[$_SESSION['selected_head']] ?>">
                                        </div>
                                        <div style="width: 28%">
                                            <label class="text" style="padding-bottom: 10px">Sub Category</label><br>
                                            <input type="text" class="custom-select" name="sub_category" value="<?= $budgetOptions[$_SESSION['selected_head']] ?>">
                                        </div>
                                        <div style="background: none; border: none; padding-top: 30px; ">
                                            <input type="submit" name="update_row" value="UPDATE"
                                            style="background-color: rgba(39, 10, 78, 0.973); padding: 10px 30px; border-radius: 70px; border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;">
                                        </div>
                                    </div>
                                </form>
                            <?php endif; ?>
                            <?php if (!empty($_SESSION['budget_rows'])): ?>
                                <form>
                                    <div style="padding-left: 50px; padding-right: 50px; padding-bottom: 10px; padding-top: 20px">
                                        <table>
                                            <thead>
                                                <tr style="background-color: #a10101; color: white;">
                                                    <th>Code</th>
                                                    <th>Budget Heads</th>
                                                    <th>Sub Category</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($_SESSION['budget_rows'] as $row): ?>
                                                    <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                                        <td><?= htmlspecialchars($row['code']) ?></td>
                                                        <td><?= htmlspecialchars($row['head']) ?></td>
                                                        <td><?= htmlspecialchars($row['sub']) ?></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </form>
                            <?php endif; ?>
                        </div> 
                    </div>
                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>