<?php
  session_start();

  // Require user to be logged in
  if (!isset($_SESSION['username'])) {
      header("Location: LoginPage.php");
      exit();
  }

  // Check for session hijacking (IP address change)
  if (!isset($_SESSION['user_ip'])) {
      $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
  } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
      session_unset();
      session_destroy();
      header("Location: LoginPage.php");
      exit();
  }

  // Session timeout logic
  $timeout = 600; // 10 minutes
  if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
      session_unset();
      session_destroy();
      header("Location: LoginPage.php");
      exit();
  }
  $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
      rel="stylesheet"
    />
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
      rel="stylesheet"
      integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
      crossorigin="anonymous"
    />
    <link rel="stylesheet" href="assets/css/styles.css" />
    <title>NED ACADEMY</title>
  </head>
  <body>
    <div class="form-container">
      <div class="container" style="padding-top: 130px; padding-bottom: 100px">
        <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
              <div class="container1">
                <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                  <div class="py-2 text-left">
                    <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                  </div>
                  <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">GENERAL</h2>
                  <div style="display: flex; justify-content: flex-end; padding: 10px;">
                    <button class="logout-btn" style="background: none; border: none;">
                      <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                        LOGOUT
                      </a>
                    </button>
                  </div>
                  <div style="padding-left: 30px;">
                    <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                      BACK
                    </button>
                  </div>
                </div>
              </div>

              <div style="display: flex;">
                  <!-- Sidebar -->
                  <div class="container2" style="background-color: whitesmoke; width: 20%;">
                      <div class="side-bar-menu">
                      <a href="PgdUgd.php" class="link">
                          <span class="menu-icon">
                          <img src="assets/img/pgdugd.png" alt="PGD/UGD" />
                          </span>
                          <span style="font-weight: bolder;">PGD / UGD</span>
                      </a>
                      </div>
                      <div class="side-bar-menu">
                      <a href="Certificates.php" class="link">
                          <span class="menu-icon">
                          <img src="assets/img/certificates.png" alt="Certificates" />
                          </span>
                          <span style="font-weight: bolder;">Certificates</span>
                      </a>
                      </div>
                      <div class="side-bar-menu">
                      <a href="PGCC.php" class="link">
                          <span class="menu-icon">
                          <img src="assets/img/pgcc.png" alt="PGCC" />
                          </span>
                          <span style="font-weight: bolder;">PGCC</span>
                      </a>
                      </div>
                      <div class="side-bar-menu">
                      <a href="Accounts.php" class="link">
                          <span class="menu-icon">
                          <img src="assets/img/accounts.png" alt="Accounts" />
                          </span>
                          <span style="font-weight: bolder;">Accounts</span>
                      </a>
                      </div>
                      <div class="side-bar-menu">
                      <a href="Attendance.php" class="link">
                          <span class="menu-icon">
                          <img src="assets/img/attendance.png" alt="Attendance" />
                          </span>
                          <span style="font-weight: bolder;">Attendance</span>
                      </a>
                      </div>
                      <div class="side-bar-menu">
                      <a href="General.php" class="link">
                          <span class="menu-icon">
                          <img src="assets/img/general.png" alt="General" />
                          </span>
                          <span style="font-weight: bolder;">General</span>
                      </a>
                      </div>
                  </div>

                  <div class="container3" style="background: linear-gradient(to bottom, #061f2d, rgba(10, 10, 44, 0.7), #525649 155%); width: 80%;">
                      <div style="display: flex; flex-wrap: wrap; padding: 60px; justify-content: space-between; margin-right: 20px;">
                        <a href="UserAccess.php"><button class="button-main" style="width: 110%; padding-top: 33px; padding-bottom: 30px;">Add User / User Access</button></a>
                        <a href="MarketingPage.php" ><button class="button-main" style="width: 144%; padding-top: 33px; padding-bottom: 30px; position: relative; right: 24px;">Marketing Page</button></a>
                        <a href="StudentFeeDiscount.php"><button class="button-main" style="width: 120%; padding-top: 33px; padding-bottom: 30px;">Student Fee Discount</button></a>
                        <a href="OldSemesterBlock.php" style="width: 20%;"><button class="button-main" style="width: 110%; padding-top: 33px; padding-bottom: 30px;">Old Semester Block</button></a>
                      </div>
                      <!-- <div style="margin-left: 60px;">
                        <a href="RegistrationFormCertificate.php"><button class="button-main" style="padding-top: 20px; padding-bottom: 20px; width: 21%;">Certificate Registration Form </button></a>
                      </div> -->
                  </div>
              </div>

              <!-- Footer -->
              <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                  <span style="color: white; font-weight: 600; ">
                    © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                  </span>
                </p>
              </div>
            </div>
          </div>
      </div>
  </body>
</html>