<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">GENERATE CSV FILE</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                    LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <form name="myform" method="POST" action="csvfile">
                            <div style="display: flex; justify-content: space-between; margin-left: 50px; margin-right: 50px; padding-top: 30px;">
                                <div >
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;"><span style="color:Red; font-size:medium;">*</span>&nbsp;Programme Name</label>
                                    <select onclick="selOpt()" class="custom-select" id="programme" name="programme" onchange="return jsFunction(this);">
                                        <option value="0" >Select</option>
                                        <option value="1">PGD </option>
                                        <option value="2">UGD </option>
                                    </select>

                                    <!-- JavaScript inside or below form -->
                                    <script>
                                        document.getElementById('programme').addEventListener('change', function () {
                                            if (this.value === '2') {
                                                window.location.href = 'GenerateCSVFileUGD.php';
                                            }
                                        });
                                    </script>
                                </div>
                                <div id="div1">
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;"><span style="color:Red; font-size:medium;">*</span>&nbsp;PGD Name</label>
                                    <select class="custom-select" id="crtname1" name="crtname1">
                                        <option value="0" >Select</option>
                                        <option value="All">All</option>
                                    </select>
                                </div>
                                <div  id="sem">
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;"><span style="color:Red; font-size:medium;">*</span>&nbsp;Semester</label>
                                    <select class="custom-select" id="semester" name="semester" onkeypress="clearBox();" style="width:100.0%;" required="">
                                        <option value="0" >Select</option>
                                    </select>
                                </div>
                                <div >
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;"><span style="color:Red; font-size:medium;">*</span>&nbsp;Type</label>
                                    <select class="custom-select" id="type" name="type">
                                        <option value="0">Select</option>
                                        <option value="EqualtoZero" >Equal To Zero</option>
                                        <option value="Equal" >Equal</option>
                                        <option value="Greater">Greater</option>
                                        <option value="EqualGreater">Equal &amp; Greater</option>
                                        <option value="Less">Less</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="text" style="padding-bottom: 10px;"><span style="color:Red; font-size:medium;">*</span>&nbsp;Amount</label>
                                    <input type="text" class="custom-select" id="amount" name="amount" placeholder="XXXXXX">
                                </div>
                            </div>
                            <div style="display: flex; justify-content: center; padding-top: 40px;">
                                <input type="submit" value="GENERATE"
                                style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                            </div>
                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                    <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                        <span style="color: white; font-weight: 600; ">
                        © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                        </span>
                    </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>