<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">GENERATE OLD SEMESTER VOUCHERS</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>   
                            </div>
                        </div>
                    </div>

                    <div class="container2" style="padding: 50px;">
                        <form action="setadmit" method="POST" onsubmit="return validate(this)">
                            <input type="hidden" id="programe1" name="programe1" value="Certificate">
                            <input type="hidden" id="yearid1" name="yearid1" value="null">
                            <input type="hidden" id="title1" name="title1" value="57866">
                            <input type="hidden" id="batchno1" name="batchno1" value="null">
                            <div style="padding: 50px; padding-top: 0px;">
                                <table>
                                    <thead>
                                        <tr style="background-color: #a10101; color: white;">
                                            <th>StudentID</th>
                                            <th>Name</th>
                                            <th>Father Name</th>
                                            <th>CNIC</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Repeat rows dynamically -->
                                        <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </form>

                        <div style="display: flex; margin-left: 50px; padding-bottom: 30px; gap: 6.5%">
                            <div>
                                <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;"><span style="color:Red; font-size:medium;">*</span>&nbsp;Amount</label>
                                <input required="" class="custom-select" type="text" placeholder="AMOUNT" name="amount" id="amount" style="width: 120%;">  
                            </div>
                            <div>
                                <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;"><span style="color:Red; font-size:medium;">*</span>&nbsp;Course Type</label>
                                <select id="mySelect" name="mySelect" class="custom-select" style="width: 108%;">   
                                    <option value="0" selected="selected">Select</option>           
                                    <option value="31">Continuing Professional Development (CPD) </option>
                                    <option value="9">Course Fee </option>
                                    <option value="12">Degree Fee </option>
                                    <option value="11">Elective </option>
                                    <option value="32">Fee Installment </option>
                                    <option value="46">Improvement of Course - Course Fee </option>
                                    <option value="45">Improvement of Course - Monthly Fee </option>
                                    <option value="16">Issuance of Bonafide Certificate </option>
                                    <option value="17">Issuance of Course Wise Certificate </option>
                                    <option value="36">Issuance of Medium of Instruction Letter </option>
                                    <option value="19">Issuance of PGC </option>
                                    <option value="21">Issuance of PGC (Duplicate) </option>
                                    <option value="20">Issuance of PGD (Duplicate) </option>
                                    <option value="18">Issuance of PGD + Transcript </option>
                                    <option value="22">Issuance of Provisional Certificate </option>
                                    <option value="34">LumSum Fee </option>
                                    <option value="8">Monthly Fee </option>
                                    <option value="35">PGC Certificate </option>
                                    <option value="10">Project </option>
                                    <option value="29">Re-Assessment per course </option>
                                    <option value="13">Re-Examination (Final) </option>
                                    <option value="14">Re-Examination (Mid-Term) </option>
                                    <option value="42">Re-assessment per course (Re-checking of sessional and final exam marks) </option>
                                    <option value="1">Registration Fee </option>
                                    <option value="40">Remaining Fee </option>
                                    <option value="41">Scrutiny of Results per course (Re-counting of sessional and final exam marks) </option>
                                    <option value="28">TCS </option>
                                    <option value="7">Total Fee </option>
                                </select>
                            </div>
                            <div style="position: relative; top: 30px;">
                                <input type="submit" value="GENERATE"
                                style="background-color: rgba(39, 10, 78, 0.973);  padding: 10px 27px; border-radius: 70px; border: transparent; color: white; font-family: system-ui; 
                                    font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;">
                            </div>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="container4" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <script>
            // Clear the URL parameters (only once, when page is loaded after redirect)
            if (performance.navigation.type === performance.navigation.TYPE_NAVIGATE || performance.getEntriesByType("navigation")[0].type === "navigate") {
                if (window.location.href.indexOf('?') > -1) {
                    window.history.replaceState({}, document.title, window.location.pathname);
                }
            }
        </script>
    </body>
</html>