<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">GENERATE OLD VOUCHERS</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                    LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <div style="display: flex; justify-content: space-between; margin-left: 28px; margin-right: 15px; gap: 3%">
                            <div >
                                <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;"><span style="color:Red; font-size:medium;">*</span>&nbsp;Certificate Title</label>
                                <input class="custom-select" type="text" placeholder="STUDENT_NAME" name="stname" id="stname" style="width:100.0%; " value="Old Batches" readonly="readonly">
                            </div>
                            <div style="width: 100%;">
                                <label class='text'><span style= "color: red; font-size: medium; padding-right: 6px">*</span>Course Title</label><br />
                                <div style="padding-top: 9px">
                                    <select class ='custom-select' name="courseTitle" value={formData.courseTitle} required>
                                        <option value="0" >Select</option>                                   
                                        <option value="143">World Englishes and Technology in Language </option>
                                        <option value="93">World Class Safety Management </option>
                                        <option value="44">World Class Manufacturing Management </option>
                                        <option value="60">Welding Techniques And Inspections </option>
                                        <option value="225">Web designing and Development </option>
                                        <option value="136">Web Development Via PhP </option>
                                        <option value="200">Water Treatment For Cooling Towers And Boiler Feed </option>
                                        <option value="183">Waste Heat Recovery Management And Capex </option>
                                        <option value="217">Visual Designing &amp; Art Direction </option>
                                        <option value="290">Vibration Monitoring &amp; Analysis </option>
                                        <option value="214">Unreal Engine </option>
                                        <option value="288">Unity Certified Associate (UCA) Game Developer Course </option>
                                        <option value="66">Understanding, Predicting, Preventing, Precautions And Remedies For Membrane Scaling &amp; Membrane Foul </option>
                                        <option value="54">Understanding Of Sheet Metal Parts Production </option>
                                        <option value="172">UI/UX </option>
                                        <option value="96">UI UX And Design Thinking </option>
                                        <option value="324">Turtle Soup (TS) and Candle Range Theory (CRT) </option>
                                        <option value="291">The Early Childhood Education </option>
                                        <option value="176">Textile Printing And Finishing </option>
                                        <option value="83">Textile Brand Management And Marketing </option>
                                        <option value="205">Textile Brand Management &amp; Marketing </option>
                                        <option value="315">Technology Transformation Dissemination Session (CPD Certificate) </option>
                                        <option value="331">Technology Driven Climate Action (Climatech 2025) (CPD Certificate) </option>
                                        <option value="382">Technical Training in Knitting Mechanics and Fabric Calculations </option>
                                        <option value="194">Technical Analysis For Trading Financial Markets </option>
                                        <option value="276">Taxation </option>
                                        <option value="30">Sustainable Waste Management </option>
                                        <option value="319">Sustainable Financing </option>
                                        <option value="67">Sustainable Corporate Management </option>
                                        <option value="98">Sustainability - Economics, Tools, Management </option>
                                        <option value="304">Sustainability &amp; Sustainable Product Development &amp; Profitable Future: Driving Growth with Life Cycle Assessment (LCA) </option>
                                        <option value="281">Supply Chain Management 360 </option>
                                        <option value="151">Supply Chain Management </option>
                                        <option value="27">Supply Chain Design And Management </option>
                                        <option value="329">Strategic Marketing in Banking </option>
                                        <option value="110">Strategic Management For Professional Managers And Senior Engineers </option>
                                        <option value="58">Strategic Management </option>
                                        <option value="231">Strategic Human Resource Management  </option>
                                        <option value="385">Storage and Warehouse Techniques </option>
                                        <option value="68">Steady State Process Simulation For Typical Process Equipment </option>
                                        <option value="255">Steady State And Dynamic Process Simulation </option>
                                        <option value="127">Statistical Quality Control For Professionals </option>
                                        <option value="192">Solidworks For Engineers &amp; Freelancers </option>
                                        <option value="201">Solar Panel System Installation for Electrical/Electronics Engineers </option>
                                        <option value="216">Software Engineering Principals </option>
                                        <option value="36">Software Engineering And Java Programming </option>
                                        <option value="138">Software Development (Foundation) </option>
                                        <option value="33">SketchUp And VRay Basic Workshop For Interior Design </option>
                                        <option value="264">Six-Sigma (Green Belt) </option>
                                        <option value="334">Shopify and Meta Ads </option>
                                        <option value="86">Sewn Product Engineering </option>
                                        <option value="211">Self-Effectiveness &amp; Professional Development </option>
                                        <option value="122">Self Defence Programme </option>
                                        <option value="55">Security Operations Centre (SOC) Analyst </option>
                                        <option value="354">Sample </option>
                                        <option value="8">Safety and Quality in the Food Processing </option>
                                        <option value="241">SUMMER CAMP | WoodCrafting 101 (Group 2) </option>
                                        <option value="240">SUMMER CAMP | WoodCrafting 101 (Group 1) </option>
                                        <option value="232">SUMMER CAMP | Web designing (Group 2) </option>
                                        <option value="47">SUMMER CAMP | Web designing (Group 1) </option>
                                        <option value="362">SUMMER CAMP | Web designing  </option>
                                        <option value="371">SUMMER CAMP | Web Building with WordPress  </option>
                                        <option value="370">SUMMER CAMP | UI/UX (FIGMA) Design Beginners </option>
                                        <option value="366">SUMMER CAMP | Theatre Arts </option>
                                        <option value="368">SUMMER CAMP | Textile Tech </option>
                                        <option value="243">SUMMER CAMP | Textile Journey from Fibre to Fabric </option>
                                        <option value="248">SUMMER CAMP | Soccer Camp (Group 2) </option>
                                        <option value="247">SUMMER CAMP | Soccer Camp (Group 1) </option>
                                        <option value="378">SUMMER CAMP | Smart Choices: A Camp for Young Decision Makers </option>
                                        <option value="365">SUMMER CAMP | Short Film </option>
                                        <option value="375">SUMMER CAMP | Robotics </option>
                                        <option value="257">SUMMER CAMP | Power Skills For Youth </option>
                                        <option value="372">SUMMER CAMP | Power BI for Beginners </option>
                                        <option value="374">SUMMER CAMP | Office Camp: Master Word, Excel &amp; Power Point </option>
                                        <option value="239">SUMMER CAMP | New Media Technology (Group 2) </option>
                                        <option value="238">SUMMER CAMP | New Media Technology (Group 1) </option>
                                        <option value="367">SUMMER CAMP | Media Production </option>
                                        <option value="263">SUMMER CAMP | Learn with Fun Python Coding (Group 3) Tue &amp; Thu I 12:30PM - 2:30PM </option>
                                        <option value="388">SUMMER CAMP | Learn with Fun Python Coding (Group 3) </option>
                                        <option value="236">SUMMER CAMP | Learn with Fun Python Coding (Group 2) </option>
                                        <option value="235">SUMMER CAMP | Learn with Fun Python Coding (Group 2) </option>
                                        <option value="46">SUMMER CAMP | Learn with Fun Python Coding (Group 1) </option>
                                        <option value="387">SUMMER CAMP | Learn Keys or Strings </option>
                                        <option value="45">SUMMER CAMP | IoT for Beginners </option>
                                        <option value="262">SUMMER CAMP | Graphics Design (Group 3) Mon &amp; Wed I 4PM-6PM </option>
                                        <option value="237">SUMMER CAMP | Graphics Design (Group 2) </option>
                                        <option value="49">SUMMER CAMP | Graphics Design (Group 1) </option>
                                        <option value="383">SUMMER CAMP | Graphics Design </option>
                                        <option value="389">SUMMER CAMP | Generative (AI) (Group 2) </option>
                                        <option value="244">SUMMER CAMP | Generative (AI) (Group 1) </option>
                                        <option value="377">SUMMER CAMP | Fine Arts </option>
                                        <option value="245">SUMMER CAMP | English Language (Speaking Skills) (Group 2) </option>
                                        <option value="6">SUMMER CAMP | English Language (Speaking Skills) (Group 1) </option>
                                        <option value="246">SUMMER CAMP | English Language (Essay Writing) (Group 2) </option>
                                        <option value="39">SUMMER CAMP | English Language (Essay Writing) (Group 1) </option>
                                        <option value="369">SUMMER CAMP | English Language (Essay Writing) </option>
                                        <option value="373">SUMMER CAMP | Data Analytics with Excel &amp; Google Sheet </option>
                                        <option value="363">SUMMER CAMP | Creative design </option>
                                        <option value="364">SUMMER CAMP | Cartoon Animation with Adobe Animate </option>
                                        <option value="261">SUMMER CAMP | Cartoon Animation With Adobe Animate For Kids (Group 2) Mon &amp; Wed | 2PM - 4PM </option>
                                        <option value="242">SUMMER CAMP | Cartoon Animation With Adobe Animate For Kids (Group 1) </option>
                                        <option value="48">SUMMER CAMP | Basic Electronics (Group 1) </option>
                                        <option value="253">SUMMER CAMP | Archery Camp  </option>
                                        <option value="50">SUMMER CAMP | AR, VR Technologies Experience  </option>
                                        <option value="234">SUMMER CAMP | AI For Beginners (Group 2) </option>
                                        <option value="233">SUMMER CAMP | AI For Beginners (Group 1) </option>
                                        <option value="361">SUMMER CAMP | AI For Beginners (Group 1) </option>
                                        <option value="376">SUMMER CAMP | 3D Animation </option>
                                        <option value="182">SQL For Relational Database Management System (RDBMS) </option>
                                        <option value="126">SAP-MM Material Managament </option>
                                        <option value="81">SAP ABAP </option>
                                        <option value="282">Retail Operations and Customer Experience </option>
                                        <option value="332">Raspberry PI and Python Programming </option>
                                        <option value="310">Quantum Workshops (CPD Certificate)  </option>
                                        <option value="119">Pytorch For Data Scientists </option>
                                        <option value="185">Python Programming Advance </option>
                                        <option value="249">Public Administration Professional </option>
                                        <option value="208">Psychrometry, Heat load Estimation for  Air conditioning and Refrigeration Applications </option>
                                        <option value="342">Project Risk Management </option>
                                        <option value="71">Project Management Using MS Project </option>
                                        <option value="23">Project Management Tools (PRIMAVERA And AGILE) </option>
                                        <option value="104">Project Management Processes </option>
                                        <option value="19">Project Management Framework And Tools </option>
                                        <option value="164">Programming with Data Structures </option>
                                        <option value="18">Professional Certification In Aviation Management </option>
                                        <option value="325">Productivity Improvement by Better Time Management </option>
                                        <option value="149">Procurement Management  </option>
                                        <option value="91">Process Safety Management </option>
                                        <option value="24">Principles Of Marketing </option>
                                        <option value="116">Pressure Die-Casting Production </option>
                                        <option value="85">Predictive HR Analytics </option>
                                        <option value="209">Power System Analysis </option>
                                        <option value="31">Plant Operation, Maintenance And Safety </option>
                                        <option value="220">Photography </option>
                                        <option value="87">Pharmaceutical Unit Operations </option>
                                        <option value="17">Performance Management And Managerial Accounting Practices In Aviation </option>
                                        <option value="26">Performance Appraisal And Compensation Management </option>
                                        <option value="125">PHP Server Scripting Language </option>
                                        <option value="347">PGCC Duplicate Certificate </option>
                                        <option value="79">Organizational Performance Improvement </option>
                                        <option value="105">Organizational Management </option>
                                        <option value="64">Oracle Database Administration For Beginners </option>
                                        <option value="118">Oracle Business Intelligence Enterprise Edition (OBIEE 12c) </option>
                                        <option value="380">Oracle 9i </option>
                                        <option value="170">Operating system </option>
                                        <option value="390">OO </option>
                                        <option value="258">ODOO Supply-Chain Management System For Trading Industry </option>
                                        <option value="106">Non Destructive Techniques And International Practice In Industries </option>
                                        <option value="222">Network Security </option>
                                        <option value="223">Network Configuration and Management </option>
                                        <option value="344">Navigating Research with Purpose </option>
                                        <option value="311">NLP Tutorial (CPD Certificate) </option>
                                        <option value="117">NLP Practitioner </option>
                                        <option value="295">NED-habbah parwaaz programme </option>
                                        <option value="307">NED Archery Club </option>
                                        <option value="394">NEBOSH IGC Training </option>
                                        <option value="77">Motion Graphics Editing And 2D Animation </option>
                                        <option value="175">Modelling and Animation </option>
                                        <option value="35">Mobile App Development With FLUTTER And DART </option>
                                        <option value="76">Mind Sciences And Mind Engineering Professional </option>
                                        <option value="4">Mechanical Engineering Practices and Concepts In Industry </option>
                                        <option value="340">Mastering: A Comprehensive Training in 2D &amp; 3D Virtual Garment Design </option>
                                        <option value="62">Mastering The Entrepreneurial Process </option>
                                        <option value="349">Mastering Investment Strategies To Build Generational Wealth </option>
                                        <option value="53">Mastering Exam Procedures Best Practices For Administrators </option>
                                        <option value="109">Mastering Amazon Wholesale FBA (USA) With Practical Approach </option>
                                        <option value="120">Maintenance Management, Operational Excellence, Technical Project &amp; Safety Management </option>
                                        <option value="80">Maintenance And Reliability In Plant Operations </option>
                                        <option value="61">Machine Learning </option>
                                        <option value="69">Logistics, Transportation And Distribution Management </option>
                                        <option value="51">Logistics </option>
                                        <option value="130">Lifting Equipment Inspection </option>
                                        <option value="357">Lean Six Sigma &amp; Lean Manufacturing </option>
                                        <option value="25">Lean Six Sigma </option>
                                        <option value="57">Lean Fundamentals For Service And Manufacturing Organizations </option>
                                        <option value="88">Leadership And Motivation </option>
                                        <option value="11">Language Testing And Assessment </option>
                                        <option value="128">Labs Based Approach To Docker Containers And Kubernetes Containers Orchestration </option>
                                        <option value="20">Inventory Management </option>
                                        <option value="300">Introduction to Pressure Vessels based on ASME VIII Div. 1 and API - 510 </option>
                                        <option value="162">Introduction to Physics In Game Development </option>
                                        <option value="337">Introduction to Financial Management </option>
                                        <option value="351">Introduction to Electric Vehicles EVs </option>
                                        <option value="100">Introduction To Asset Valuation </option>
                                        <option value="250">Introduction To Artificial Intelligence For Engineers </option>
                                        <option value="328">Interpreter Development for CNC Controller - G&amp;M Codes to Digital Signals </option>
                                        <option value="22">International And Best Value Procurement </option>
                                        <option value="313">Interior Design Workshop For Beginners </option>
                                        <option value="15">Information Risk Management </option>
                                        <option value="289">Industrial Steam Boiler System, Operation, Maintenance and Safety </option>
                                        <option value="7">Industrial Psychology and Organizational Behaviour </option>
                                        <option value="196">Industrial Energy Management </option>
                                        <option value="330">Implement Energy Management System ISO 50001:2018 and Reduce Energy Cost </option>
                                        <option value="159">IOT Principles and Design </option>
                                        <option value="5">IELTS Preparation  </option>
                                        <option value="251">ICT Trading Algorithm Masterclass (Crypto, Forex And Stocks) </option>
                                        <option value="9">Hypnosis </option>
                                        <option value="154">Human Resource Management </option>
                                        <option value="144">Health &amp; Safety Foundation </option>
                                        <option value="12">Hazard Recognition &amp; Risk Mitigation Strategies </option>
                                        <option value="63">Halal Management System </option>
                                        <option value="3">HR Generalist </option>
                                        <option value="323">Guided Project: Developing Blockchain Based e-kyc (know your customer) Application Project </option>
                                        <option value="180">Green Financing </option>
                                        <option value="212">Graphics designing </option>
                                        <option value="97">Governance, Risk And Compliance (GRC) In Cyber Security </option>
                                        <option value="34">Global Logistics And Supply Chain Management </option>
                                        <option value="228">Generative AI to Data Science </option>
                                        <option value="213">Game Modelling By Unity 2D and 3D, Illustrator </option>
                                        <option value="78">GRE Preparation </option>
                                        <option value="272">GIZ Professional Course on Sustainable Productivity Practices through DfS </option>
                                        <option value="327">GIZ Professional Course on Sustainable Productivity Practices for Professionals (A Complete Toolkit) </option>
                                        <option value="273">GIZ Professional Course on Dialogue for Sustainability </option>
                                        <option value="157">Fundamentals of Sustainable Engineering </option>
                                        <option value="338">Functional Reverse Engineering </option>
                                        <option value="142">Functional Foods </option>
                                        <option value="199">Full Stack Development </option>
                                        <option value="13">Front End Designing </option>
                                        <option value="198">Foundation Courses for PMA Graduates </option>
                                        <option value="317">Fire Loss Control - Roof Mounted Photovoltaic Systems </option>
                                        <option value="274">Financial Skills For Non-Finance Leaders &amp; Executives </option>
                                        <option value="153">Financial Reporting </option>
                                        <option value="206">Fabric Preparatory Processes </option>
                                        <option value="52">Exploring Enterprise Resource Planning </option>
                                        <option value="252">Explore &amp; Learn Profitable Management </option>
                                        <option value="2">Ethical Hacking </option>
                                        <option value="195">Entrepreneurship The Game Changer </option>
                                        <option value="254">Entrepreneurial Vermicomposting From Waste To Wealth </option>
                                        <option value="309">English Language Extensive Speaking and Writing Proficiency Course-Level 2 </option>
                                        <option value="308">English Language Extensive Speaking Course-Level 1 </option>
                                        <option value="59">English Language Extensive Speaking Course </option>
                                        <option value="10">Engineering Insurance </option>
                                        <option value="99">Energy Conservation </option>
                                        <option value="155">Energy Audits </option>
                                        <option value="224">Email Marketing &amp; Paid Search (PPC) using  Google Ads </option>
                                        <option value="108">Effective Written Communication And Ethics For Professionals </option>
                                        <option value="193">E-Commerce </option>
                                        <option value="286">Dummy GI </option>
                                        <option value="287">Dummy GI </option>
                                        <option value="335">Digital Twinning-Discrete Manufacturing </option>
                                        <option value="301">Digital Technology in Supply Chain </option>
                                        <option value="121">DevOps Engineering </option>
                                        <option value="158">Design Principles for Metaverse </option>
                                        <option value="181">Design &amp; Development Concepts In Air Conditioning With Modern Practices </option>
                                        <option value="163">Denim Product Development &amp; Design </option>
                                        <option value="84">Denim Manufacturing Processes </option>
                                        <option value="89">Deep Learning </option>
                                        <option value="218">Database Management Systems (DBMS) </option>
                                        <option value="137">Database Designing &amp;  Development </option>
                                        <option value="90">Data Visualization </option>
                                        <option value="360">Data Analytics for Engineers </option>
                                        <option value="72">Data Analyst In Microsoft Power BI </option>
                                        <option value="179">Data Analyst In Microsoft Excel And SQL </option>
                                        <option value="294">Cyber Security for Web 3.0 and Blockchain </option>
                                        <option value="16">Cyber Security Offensive </option>
                                        <option value="135">Cyber Security (Foundation) </option>
                                        <option value="133">Cyber Security (Defensive) </option>
                                        <option value="134">Cyber Security (Core) </option>
                                        <option value="132">Cyber Law </option>
                                        <option value="259">Customer Relationship Management (CRM) </option>
                                        <option value="94">Cryptography For Blockchain </option>
                                        <option value="271">Corporate Sustainability Integrating Governance Monitoring And Reporting </option>
                                        <option value="292">Conversion Course </option>
                                        <option value="160">Controllers for Mechatronics </option>
                                        <option value="148">Contracts Management </option>
                                        <option value="101">Construction Project Management Framework And Implementation </option>
                                        <option value="146">Construction Materials Technology &amp; Processes  </option>
                                        <option value="21">Construction Informatics And Cost Estimation </option>
                                        <option value="280">Constructing Safety Best Practices for a Safe Worksite </option>
                                        <option value="197">Condition Monitoring &amp; Maintenance Strategies </option>
                                        <option value="107">Computer Security </option>
                                        <option value="147">Computer Aided Power System Analysis </option>
                                        <option value="28">Computer Aided Pattern Design And Product Development </option>
                                        <option value="145">Computer Aided Construction  Project Management using  Primavera &amp; Building Information  Modelling </option>
                                        <option value="65">Computational Fluid Dynamics </option>
                                        <option value="129">Communication Skills For Professional </option>
                                        <option value="123">Communication Skills For English Language Teachers </option>
                                        <option value="124">Communication Master Class </option>
                                        <option value="95">Cloud Platform And Infrastructure Security </option>
                                        <option value="161">Cloud Computing Data Security </option>
                                        <option value="293">Chinese Language Course </option>
                                        <option value="38">Certified Web Engineering Professional </option>
                                        <option value="184">Certified Supply Chain Professional (CSCP) </option>
                                        <option value="37">Certified Software Engineering Professional </option>
                                        <option value="345">Certified Safety Officer </option>
                                        <option value="339">Certified Risk Manager CRM Training </option>
                                        <option value="188">Certified Quality Assurance Professional (CQAP) </option>
                                        <option value="303">Certified Project Management Professional (WITH PMP/CAPM EXAM PREPARATION) </option>
                                        <option value="82">Certified Professional Trainer/Master Trainer </option>
                                        <option value="114">Certified Professional Safety Practitioner (CPSP) </option>
                                        <option value="113">Certified Practitioner Of Industrial Psychology And Organizational Behaviour </option>
                                        <option value="112">Certified Practitioner Human Resource (CPHR) With Applied Methodology Of PHRi/ SPHRi </option>
                                        <option value="384">Certified Petroleum Professional (CPP) </option>
                                        <option value="75">Certified Organizational Development Practitioner </option>
                                        <option value="191">Certified Lean Management Professional (CLMP) </option>
                                        <option value="111">Certified Labor Laws Practitioner &amp; Industrial Relations Analyst </option>
                                        <option value="189">Certified Labor Laws &amp; Industrial Relations Professional (CLLIRP) </option>
                                        <option value="187">Certified Human Resource Professional (CHRP) </option>
                                        <option value="381">Certified Health and Physical Education Specialist </option>
                                        <option value="32">Certified Fire Protection Facilitator </option>
                                        <option value="203">Certified Cyber Security Professional </option>
                                        <option value="115">Certified Accounting Software Professional (With ERP Implementation) </option>
                                        <option value="56">Certification In Islamic Banking And Finance </option>
                                        <option value="336">Certificate in Engineering, Construction and Industrial Risk Insurance </option>
                                        <option value="285">Certificate - verification - fee </option>
                                        <option value="140">Business Intelligence </option>
                                        <option value="102">Business And Taxation Laws </option>
                                        <option value="279">Business Analytics Specialization </option>
                                        <option value="230">Business &amp; Taxation Laws </option>
                                        <option value="202">Building Information Modeling for Civil/Urban Engineers and B.Arch. </option>
                                        <option value="70">Boiler Safety And Energy Audit To Conserve Energy </option>
                                        <option value="391">Blockchain for Medical Professionals </option>
                                        <option value="348">Basics Of Robotics Systems </option>
                                        <option value="284">B-Tech </option>
                                        <option value="74">Automotive Technician </option>
                                        <option value="207">Automotive Electrical and Electronics </option>
                                        <option value="103">Auditing And Assurance </option>
                                        <option value="318">Arduino Masterclass </option>
                                        <option value="73">Approaches And Methods In Language Teaching </option>
                                        <option value="275">Applied Lean Manufacturing With Cost Efficiency </option>
                                        <option value="29">Apparel And Merchandising Management </option>
                                        <option value="156">Agile and Lean Manufacturing </option>
                                        <option value="219">Advanced Techniques in Photography </option>
                                        <option value="256">Advanced Techniques In Renewables Energy And Storage </option>
                                        <option value="150">Advanced Project Management Processes </option>
                                        <option value="92">Advanced Blockchain Technology For Enterprises </option>
                                        <option value="215">Advance Web Programming via PhP </option>
                                        <option value="227">Advance Blockchain Technology for  Enterprises  </option>
                                        <option value="152">Accounting and Financial Management </option>
                                        <option value="314">7-Week Solidworks for Engineers &amp; Freelancers </option>
                                        <option value="316">4-Week ICT trading algorithm masterclass (crypto, forex and stocks) </option>
                                        <option value="260">4-Week Course on Welding Techniques And Inspections </option>
                                        <option value="299">4-Week Certified Procurement Management Professional </option>
                                        <option value="174">3D Modelling with Blender </option>
                                        <option value="139">3D Foundation Using MAYA </option>
                                        <option value="221">3D Animation </option>
                                        <option value="1">3-Month Certificate Course on Python Programming </option>
                                        <option value="302">3-Month Certificate Course on Material Management </option>
                                        <option value="278">3-Month Certificate Course on Digital Marketing </option>
                                        <option value="333">3-Month Certificate Course on Aviation Engineering Management </option>
                                        <option value="186">3-Month Certificate Course On Inventory Management </option>
                                        <option value="283">3-Day Certificate Course on Industrial Energy Management </option>
                                        <option value="346">2-Week Certificate Course on Steady State Process Simulation for Typical Process Equipment </option>
                                        <option value="379">2-Week Certificate Course on Process Safety Management </option>
                                        <option value="269">2-Month UGC course on Introduction to Gaming Industry, Game Programming,  Game Modelling (Designing) </option>
                                        <option value="277">2-Month UGC course on Introduction to Fashion &amp; Textiles </option>
                                        <option value="171">2-Month UGC course on Graphics designing </option>
                                        <option value="266">2-Month UGC course on Fundamentals of Refrigeration and selection of Refrigeration </option>
                                        <option value="173">2-Month UGC course on Design Tools And Software </option>
                                        <option value="210">2-Month UGC course on Data Visualization  </option>
                                        <option value="177">2-Month UGC Course on Textile Fibers </option>
                                        <option value="359">2-Month UGC Course on Screenwriting and Script Development	 </option>
                                        <option value="268">2-Month UGC Course on Python for AI </option>
                                        <option value="226">2-Month UGC Course on Python For Data Science </option>
                                        <option value="306">2-Month UGC Course on Pre-Treatment &amp; Dyeing </option>
                                        <option value="267">2-Month UGC Course on Power Generation, Transmission and Distribution </option>
                                        <option value="355">2-Month UGC Course on Machine Learning </option>
                                        <option value="321">2-Month UGC Course on Introduction to Media Communication </option>
                                        <option value="322">2-Month UGC Course on Introduction to Digital Media </option>
                                        <option value="165">2-Month UGC Course on Introduction to Cybersecurity </option>
                                        <option value="168">2-Month UGC Course on Introduction to Computer Networks </option>
                                        <option value="169">2-Month UGC Course on Introduction to Basic &amp; office automation </option>
                                        <option value="178">2-Month UGC Course on Introduction to Automotive Systems </option>
                                        <option value="386">2-Month UGC Course on Interior Design Fundamentals </option>
                                        <option value="305">2-Month UGC Course on Garment Manufacturing </option>
                                        <option value="320">2-Month UGC Course on Fundamentals of Film Production </option>
                                        <option value="167">2-Month UGC Course on Foundations of Visual Storytelling (Photography) </option>
                                        <option value="352">2-Month UGC Course on Fabric Preparatory Process </option>
                                        <option value="166">2-Month UGC Course on Digital Marketing Strategy Designing </option>
                                        <option value="356">2-Month UGC Course on Deep Learning </option>
                                        <option value="270">2-Month UGC Course on Computer Programming (Python) </option>
                                        <option value="204">2-Month UGC Course on Basic Drawing &amp; Illustration </option>
                                        <option value="353">2-Month UGC Course on Automotive Electrical and Electronics </option>
                                        <option value="393">2-Month UGC Course Business Intelligence </option>
                                        <option value="312">2-Month Security Operations Centre (SOC) Analyst </option>
                                        <option value="14">2-Month PGC course on Python Programming </option>
                                        <option value="358">2-Month PGC course on Products in Islamic Finance </option>
                                        <option value="229">2-Month PGC course on Logistics, Transportation and Distribution  </option>
                                        <option value="326">2-Month PGC course on Islamic Banking &amp; Finance </option>
                                        <option value="350">2-Month PGC course on Industrial Marketing </option>
                                        <option value="141">2-Month PGC Course on Python for Data Science </option>
                                        <option value="392">2-Month PGC Course on Practical Implementation of Islamic Banking </option>
                                        <option value="298">2-Month Certificate course on Computational Fluid Dynamics - Online </option>
                                        <option value="343">2-Month Certificate Course on Taxation </option>
                                        <option value="131">2-Month Certificate Course on Python Programming </option>
                                        <option value="341">12-Week Professional Certification Course on Certified Cyber Security Professional </option>
                                        <option value="297">10-Week Certificate Course on Inventory Management </option>
                                        <option value="265">(Only Online) SUMMER CAMP | Learn with Fun Python Coding (Group 4) Sat &amp; Sun I 10:30AM - 12:30PM </option>
                                        <option value="190"> Certified Health, Safety, Sustainability &amp; Environment Professional (CHSSEP) </option>
                                    </select>
                                </div>
                            </div>
                            <div >
                                <label class='text'><span style= "color: red; font-size: medium; padding-right: 6px">*</span>Country</label><br />
                                <div style="padding-top: 9px">
                                    <select class='form-control-country' name="country" required>
                                        <option value="0">Select</option>
                                        <option value="Afghanistan">Afghanistan</option>
                                        <option value="Albania">Albania</option>
                                        <option value="Algeria">Algeria</option>
                                        <option value="Andorra">Andorra</option>
                                        <option value="Angola">Angola</option>
                                        <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                                        <option value="Argentina">Argentina</option>
                                        <option value="Armenia">Armenia</option>
                                        <option value="Australia">Australia</option>
                                        <option value="Austria">Austria</option>
                                        <option value="Azerbaijan">Azerbaijan</option>
                                        <option value="Bahamas">Bahamas</option>
                                        <option value="Bahrain">Bahrain</option>
                                        <option value="Bangladesh">Bangladesh</option>
                                        <option value="Barbados">Barbados</option>
                                        <option value="Belarus">Belarus</option>
                                        <option value="Belgium">Belgium</option>
                                        <option value="Belize">Belize</option>
                                        <option value="Benin">Benin</option>
                                        <option value="Bhutan">Bhutan</option>
                                        <option value="Bolivia">Bolivia</option>
                                        <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                                        <option value="Botswana">Botswana</option>
                                        <option value="Brazil">Brazil</option>
                                        <option value="Brunei">Brunei</option>
                                        <option value="Bulgaria">Bulgaria</option>
                                        <option value="Burkina Faso">Burkina Faso</option>
                                        <option value="Burundi">Burundi</option>
                                        <option value="Cabo Verde">Cabo Verde</option>
                                        <option value="Cambodia">Cambodia</option>
                                        <option value="Cameroon">Cameroon</option>
                                        <option value="Canada">Canada</option>
                                        <option value="Central African Republic">Central African Republic</option>
                                        <option value="Chad">Chad</option>
                                        <option value="Chile">Chile</option>
                                        <option value="China">China</option>
                                        <option value="Colombia">Colombia</option>
                                        <option value="Comoros">Comoros</option>
                                        <option value="Congo (Congo-Brazzaville)">Congo (Congo-Brazzaville)</option>
                                        <option value="Costa Rica">Costa Rica</option>
                                        <option value="Croatia">Croatia</option>
                                        <option value="Cuba">Cuba</option>
                                        <option value="Cyprus">Cyprus</option>
                                        <option value="Czech Republic">Czech Republic (Czechia)</option>
                                        <option value="Democratic Republic of the Congo">Democratic Republic of the Congo</option>
                                        <option value="Denmark">Denmark</option>
                                        <option value="Djibouti">Djibouti</option>
                                        <option value="Dominica">Dominica</option>
                                        <option value="Dominican Republic">Dominican Republic</option>
                                        <option value="Ecuador">Ecuador</option>
                                        <option value="Egypt">Egypt</option>
                                        <option value="El Salvador">El Salvador</option>
                                        <option value="Equatorial Guinea">Equatorial Guinea</option>
                                        <option value="Eritrea">Eritrea</option>
                                        <option value="Estonia">Estonia</option>
                                        <option value="Eswatini">Eswatini (Swaziland)</option>
                                        <option value="Ethiopia">Ethiopia</option>
                                        <option value="Fiji">Fiji</option>
                                        <option value="Finland">Finland</option>
                                        <option value="France">France</option>
                                        <option value="Gabon">Gabon</option>
                                        <option value="Gambia">Gambia</option>
                                        <option value="Georgia">Georgia</option>
                                        <option value="Germany">Germany</option>
                                        <option value="Ghana">Ghana</option>
                                        <option value="Greece">Greece</option>
                                        <option value="Grenada">Grenada</option>
                                        <option value="Guatemala">Guatemala</option>
                                        <option value="Guinea">Guinea</option>
                                        <option value="Guinea-Bissau">Guinea-Bissau</option>
                                        <option value="Guyana">Guyana</option>
                                        <option value="Haiti">Haiti</option>
                                        <option value="Honduras">Honduras</option>
                                        <option value="Hungary">Hungary</option>
                                        <option value="Iceland">Iceland</option>
                                        <option value="India">India</option>
                                        <option value="Indonesia">Indonesia</option>
                                        <option value="Iran">Iran</option>
                                        <option value="Iraq">Iraq</option>
                                        <option value="Ireland">Ireland</option>
                                        <option value="Israel">Israel</option>
                                        <option value="Italy">Italy</option>
                                        <option value="Jamaica">Jamaica</option>
                                        <option value="Japan">Japan</option>
                                        <option value="Jordan">Jordan</option>
                                        <option value="Kazakhstan">Kazakhstan</option>
                                        <option value="Kenya">Kenya</option>
                                        <option value="Kiribati">Kiribati</option>
                                        <option value="Kuwait">Kuwait</option>
                                        <option value="Kyrgyzstan">Kyrgyzstan</option>
                                        <option value="Laos">Laos</option>
                                        <option value="Latvia">Latvia</option>
                                        <option value="Lebanon">Lebanon</option>
                                        <option value="Lesotho">Lesotho</option>
                                        <option value="Liberia">Liberia</option>
                                        <option value="Libya">Libya</option>
                                        <option value="Liechtenstein">Liechtenstein</option>
                                        <option value="Lithuania">Lithuania</option>
                                        <option value="Luxembourg">Luxembourg</option>
                                        <option value="Madagascar">Madagascar</option>
                                        <option value="Malawi">Malawi</option>
                                        <option value="Malaysia">Malaysia</option>
                                        <option value="Maldives">Maldives</option>
                                        <option value="Mali">Mali</option>
                                        <option value="Malta">Malta</option>
                                        <option value="Marshall Islands">Marshall Islands</option>
                                        <option value="Mauritania">Mauritania</option>
                                        <option value="Mauritius">Mauritius</option>
                                        <option value="Mexico">Mexico</option>
                                        <option value="Micronesia">Micronesia</option>
                                        <option value="Moldova">Moldova</option>
                                        <option value="Monaco">Monaco</option>
                                        <option value="Mongolia">Mongolia</option>
                                        <option value="Montenegro">Montenegro</option>
                                        <option value="Morocco">Morocco</option>
                                        <option value="Mozambique">Mozambique</option>
                                        <option value="Myanmar">Myanmar (Burma)</option>
                                        <option value="Namibia">Namibia</option>
                                        <option value="Nauru">Nauru</option>
                                        <option value="Nepal">Nepal</option>
                                        <option value="North Korea">North Korea</option>
                                        <option value="Netherlands">Netherlands</option>
                                        <option value="New Zealand">New Zealand</option>
                                        <option value="Nicaragua">Nicaragua</option>
                                        <option value="Niger">Niger</option>
                                        <option value="Nigeria">Nigeria</option>
                                        <option value="North Macedonia">North Macedonia</option>
                                        <option value="Norway">Norway</option>
                                        <option value="Oman">Oman</option>
                                        <option value="Pakistan">Pakistan</option>
                                        <option value="Palau">Palau</option>
                                        <option value="Palestine">Palestine State</option>
                                        <option value="Panama">Panama</option>
                                        <option value="Papua New Guinea">Papua New Guinea</option>
                                        <option value="Paraguay">Paraguay</option>
                                        <option value="Peru">Peru</option>
                                        <option value="Philippines">Philippines</option>
                                        <option value="Poland">Poland</option>
                                        <option value="Portugal">Portugal</option>
                                        <option value="Qatar">Qatar</option>
                                        <option value="Romania">Romania</option>
                                        <option value="Russia">Russia</option>
                                        <option value="Rwanda">Rwanda</option>
                                        <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                                        <option value="Saint Lucia">Saint Lucia</option>
                                        <option value="Saint Vincent and the Grenadines">Saint Vincent and the Grenadines</option>
                                        <option value="Samoa">Samoa</option>
                                        <option value="San Marino">San Marino</option>
                                        <option value="Sao Tome and Principe">Sao Tome and Principe</option>
                                        <option value="Saudi Arabia">Saudi Arabia</option>
                                        <option value="Senegal">Senegal</option>
                                        <option value="Serbia">Serbia</option>
                                        <option value="Seychelles">Seychelles</option>
                                        <option value="Sierra Leone">Sierra Leone</option>
                                        <option value="Singapore">Singapore</option>
                                        <option value="Slovakia">Slovakia</option>
                                        <option value="Slovenia">Slovenia</option>
                                        <option value="Solomon Islands">Solomon Islands</option>
                                        <option value="Somalia">Somalia</option>
                                        <option value="South Korea">South Korea</option>
                                        <option value="South Africa">South Africa</option>
                                        <option value="South Sudan">South Sudan</option>
                                        <option value="Spain">Spain</option>
                                        <option value="Sri Lanka">Sri Lanka</option>
                                        <option value="Sudan">Sudan</option>
                                        <option value="Suriname">Suriname</option>
                                        <option value="Sweden">Sweden</option>
                                        <option value="Switzerland">Switzerland</option>
                                        <option value="Syria">Syria</option>
                                        <option value="Taiwan">Taiwan</option>
                                        <option value="Tajikistan">Tajikistan</option>
                                        <option value="Tanzania">Tanzania</option>
                                        <option value="Thailand">Thailand</option>
                                        <option value="Timor-Leste">Timor-Leste</option>
                                        <option value="Togo">Togo</option>
                                        <option value="Tonga">Tonga</option>
                                        <option value="Trinidad and Tobago">Trinidad and Tobago</option>
                                        <option value="Tunisia">Tunisia</option>
                                        <option value="Turkey">Turkey</option>
                                        <option value="Turkmenistan">Turkmenistan</option>
                                        <option value="Tuvalu">Tuvalu</option>
                                        <option value="Uganda">Uganda</option>
                                        <option value="Ukraine">Ukraine</option>
                                        <option value="United Arab Emirates">United Arab Emirates</option>
                                        <option value="United Kingdom">United Kingdom</option>
                                        <option value="United States">United States</option>
                                        <option value="Uruguay">Uruguay</option>
                                        <option value="Uzbekistan">Uzbekistan</option>
                                        <option value="Vanuatu">Vanuatu</option>
                                        <option value="Vatican City">Vatican City</option>
                                        <option value="Venezuela">Venezuela</option>
                                        <option value="Vietnam">Vietnam</option>
                                        <option value="Yemen">Yemen</option>
                                        <option value="Zambia">Zambia</option>
                                        <option value="Zimbabwe">Zimbabwe</option>
                                    </select><br /> 
                                </div>
                            </div>
                        </div>

                        <div style="display: flex; justify-content: space-between; ">
                            <div style= "text-align: justify; margin-left: 24px; width: 50%;">
                                <div>
                                    <label class='text'><span style= "color: red; font-size: medium; padding-right: 6px">*</span>Name</label><br />
                                    <div style='padding-top: 10px; padding-left: 4px; padding-right: 15px'>
                                        <input class='custom-select' type="text" placeholder="Name"  name="name" required/><br />
                                    </div>
                                </div>
                            </div>

                            <div style= "text-align: justify; margin-left: 24px; width: 50%;">
                                <div >
                                    <label class='text'><span style= "color: red; font-size: medium; padding-right: 6px">*</span>Father's Name</label><br />
                                    <div style='padding-top: 10px; padding-left: 4px; padding-right: 15px'>
                                    <input class='form-control-fname' type="text" placeholder="Father's Name" name="fatherName" required/><br />
                                    </div> 
                                </div>
                            </div>
                        </div>
                            
                        <div style="display: flex; justify-content: space-between; ">
                            <div style='text-align: justify; margin-left: 25px; margin-right: 15px;'>
                                <label class='text'><span style='color: red; font-size: medium; padding-right: 6px'>*</span>Gender</label><br />
                                <div style="padding-top: 10px">
                                    <select class='form-control-gender' name="gender" required>
                                        <option value="0" >Select</option>
                                        <option>Male</option>
                                        <option>Female</option>
                                    </select><br />
                                </div>
                            </div>
                            <div style='text-align: justify; margin-left: 25px; margin-right: 15px;'>
                                <label class='text'><span style='color: red; font-size: medium; padding-right: 6px'>*</span>Email</label><br />
                                <div style="padding-top: 9px;">
                                    <input class='form-control-email' style="width: 100%;" type="email" placeholder="me@example.com" name="email" required/><br />
                                </div>
                            </div>    
                            <div style='text-align: justify; margin-left: 25px; margin-right: 15px;'>
                                <label class='text' ><span style='color: red; font-size: medium; padding-right: 6px'>*</span>CNIC</label><br />
                                <div style="padding-top: 9px;">
                                    <input class='form-control-email' style="width: 100%" type="number" placeholder="XXXXXXXXXXXXX" name="cnic" required/><br />
                                </div>
                            </div>
                            <div style='text-align: justify; margin-left: 25px; margin-right: 15px;'>
                                <label class='text' ><span style='color: red; font-size: medium; padding-right: 6px'>*</span>Mobile No</label><br />
                                <div style="padding-top: 9px;">
                                    <input class='form-control-email' style="width: 100%" type="number" placeholder="XXXXXXXXXXXXX" name="Mobile" required/><br />
                                </div>
                            </div>
                            <div style='text-align: justify; margin-left: 25px; margin-right: 15px;'>
                                <label class='text' ><span style='color: red; font-size: medium; padding-right: 6px'>*</span>WhatsApp No</label><br />
                                <div style="padding-top: 9px;">
                                    <input class='form-control-email' style="width: 100%" type="number" placeholder="XXXXXXXXXXXXX" name="Mobile" required/><br />
                                </div>
                            </div>
                            <div style='text-align: justify; margin-left: 25px; margin-right: 15px;'>
                                <label class='text' ><span style='color: red; font-size: medium; padding-right: 6px'>*</span>Amount</label><br />
                                <div style="padding-top: 9px;">
                                    <input class='form-control-email' style="width: 100%" type="number" placeholder="XXXXXX" name="Amount" required/><br />
                                </div>
                            </div>
                        </div>
                        <div class="container" style="text-align: center; padding-top: 30px;" >
                            <input type="Submit" value="Generate Voucher" class="button buttonadd" style="background-color: rgb(161, 1, 1); padding: 15px 65px; border-radius: 26px; border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer;">
                        </div>
                            
                    </div>
                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>