<?php
    session_start();

    // $host = "localhost";
    // $db_user = "root"; // default XAMPP user
    // $db_pass = ""; // default XAMPP password is blank
    // $db_name = "nedacademy";

    // // Create MySQL connection
    // $conn = new mysqli($host, $db_user, $db_pass, $db_name);
    // if ($conn->connect_error) {
    //     die("Connection failed: " . $conn->connect_error);
    // }

    include 'db.php';

    // Initialize error from session if available
    $error = $_SESSION['error'] ?? '';
    unset($_SESSION['error']);

    // Handle form POST
    if ($_SERVER["REQUEST_METHOD"] === "POST") {
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';

        // Prepare and bind
        $stmt = $conn->prepare("SELECT password FROM users WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        
        // Fetch result
        $result = $stmt->get_result();
        if ($result->num_rows === 1) {
            $row = $result->fetch_assoc();
            if (password_verify($password, $row['password'])) {
                // Set up secure session values
                $_SESSION['username'] = $username;
                $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
                $_SESSION['last_activity'] = time();

                header("Location: Dashboard.php");
                exit();
            }
            else {
                $_SESSION['error'] = "Incorrect password!";
            }
        } else {
            $_SESSION['error'] = "Username not found!";
        }

        $stmt->close();
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
      rel="stylesheet"
    />
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
      rel="stylesheet"
      integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
      crossorigin="anonymous"
    />
     <link rel="stylesheet" href="assets/css/styles.css" />
    <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="login-container">
            <div class="container">
                <div class="login-wrapper-inner">
                    <div class="login-left">
                        <img src="assets/img/ned logo.png" alt="ned logo" style="width: 100%">
                        <p>© Copyright NED Academy - NED University of Engineering & Technology 2025. All Rights Reserved</p>
                    </div>
                    <div class="login-right">
                        <h1 style="text-align: justify;">Welcome Back</h1>
                        <p style="text-align: justify; left: 6px; color: darkgray;">Please Enter Your Details</p>

                        <!-- Error alert outside layout-altering elements -->
                        <?php if (!empty($error)): ?>
                            <div class="alert alert-danger"><?= $error ?></div>
                        <?php endif; ?>

                        <form method="POST" action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>">
                            <div class="mb-3" style="display: grid; padding-top: 30px">
                                <label class="form-label fw-bold" for="username" style="text-align: justify;">UserName</label>
                                <input type="text" id="username" name="username" class="form">
                            </div>
                            <div class="mb-4" style="position: relative; top: -30px;">
                                <label class="form-label fw-bold" for="password" style="position: relative; bottom: -48px;">Password</label>
                                <input type="password" id="password" name="password" class="form2">
                            </div>
                            <div class="d-flex justify-content-between ">
                                <div class="form-check" style="position: relative; top: 30px;">
                                    <input class="form-check-input" type="checkbox" id="rememberMe">
                                    <label class="form-check-label" for="rememberMe" style="padding-left: 4px;">Remember me for 30 days</label>
                                </div>
                                <button type="button" class="btn" style="left: 2%" onclick="console.log('Forgot password clicked')">Forgot Password</button>
                            </div>
                            <button type="submit" class="login-btn">LOGIN</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>