<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();

    // DB connection
    // $conn = new mysqli("localhost", "root", "", "nedacademy");
    // if ($conn->connect_error) {
    //     die("Connection failed: " . $conn->connect_error);
    // }

    include 'db.php';

    // Fetch certificate list
    $certificates = [];
    $cert_result = $conn->query("SELECT id, certificate_name FROM certificates ORDER BY certificate_name ASC");
    if ($cert_result) {
        while ($row = $cert_result->fetch_assoc()) {
            $certificates[] = $row;
        }
    }

    // Initialize variables
    $students = [];
    $selectedCertificateId = '';

    // Handle POST request - store and redirect (PRG pattern)
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['pagename']) && $_POST['pagename'] === 'StudentDiscount') {
        $_SESSION['selectedCertificateId'] = $_POST['course'] ?? '';
        header("Location: NomineeFeesPaidForCertificate.php");
        exit();
    }

    // Handle GET request (after redirect)
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_SESSION['selectedCertificateId'])) {
        $selectedCertificateId = $_SESSION['selectedCertificateId'];

        // Clear session so next refresh shows original form
        unset($_SESSION['selectedCertificateId']);

        // Get certificate name
        $stmt = $conn->prepare("SELECT certificate_name FROM certificates WHERE id = ?");
        $stmt->bind_param("i", $selectedCertificateId);
        $stmt->execute();
        $stmt->bind_result($selectedCertificateName);
        $stmt->fetch();
        $stmt->close();

        // Fetch students for the certificate
        $stmt = $conn->prepare("SELECT student_id, name, father_name, cnic, mobile_no FROM certificate_students WHERE certificate_name = ?");
        $stmt->bind_param("s", $selectedCertificateName);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $students[] = $row;
        }
        $stmt->close();
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap" rel="stylesheet" />
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet" />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">NOMINEE FEES PAID</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">LOGOUT</a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">BACK</button>
                            </div>
                        </div>
                    </div>

                    <div class="py-3 text-center container2">
                        <div class="form-group">
                            <form method="POST" action="">
                                <input type="hidden" name="pagename" value="StudentDiscount">
                                <div style="text-align: justify; padding: 50px;">
                                    <label class="text">Certificate Name</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-course-name" name="course" required>
                                            <option value="">Select</option>
                                            <?php foreach ($certificates as $cert): ?>
                                                <option value="<?= $cert['id'] ?>" <?= ($selectedCertificateId == $cert['id']) ? 'selected' : '' ?>>
                                                    <?= htmlspecialchars($cert['certificate_name']) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                                <div style="display: flex; justify-content: center; padding-bottom: 20px; position: relative; top: -10px;">
                                    <input type="submit" value="VIEW" style="background-color: rgb(161, 1, 1); padding: 12px 70px; border-radius: 70px; border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer;" />
                                </div>
                            </form>

                            <?php if (!empty($selectedCertificateId)): ?>
                            <form action="setadmit" method="POST" onsubmit="return validate(this)">
                                <input type="hidden" name="programe1" value="Certificate">
                                <input type="hidden" name="yearid1" value="null">
                                <input type="hidden" name="title1" value="57866">
                                <input type="hidden" name="batchno1" value="null">
                                <div style="padding: 50px; padding-top: 0px;">
                                    <table>
                                        <thead>
                                            <tr style="background-color: #a10101; color: white;">
                                                <th>Student ID</th>
                                                <th>Name</th>
                                                <th>Father Name</th>
                                                <th>CNIC</th>
                                                <th>Mobile No</th>
                                                <th>Approved</th>
                                                <th>Declined</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($students)): ?>
                                                <?php foreach ($students as $student): ?>
                                                    <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                                        <td><?= htmlspecialchars($student['student_id']) ?></td>
                                                        <td><?= htmlspecialchars($student['name']) ?></td>
                                                        <td><?= htmlspecialchars($student['father_name']) ?></td>
                                                        <td><?= htmlspecialchars($student['cnic']) ?></td>
                                                        <td><?= htmlspecialchars($student['mobile_no']) ?></td>
                                                        <td><input type="checkbox" name="approved[]"></td>
                                                        <td><input type="checkbox" name="declined[]"></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                                    <td colspan="7">No records found for the selected certificate.</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </form>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="container4" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600;">&copy; Copyright NED Academy - NED University of Engineering & Technology 2025. All Rights Reserved</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>
