<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();

    $showTable = false;
    $students = [];

    // Step 1: Capture POST and redirect to GET
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['programme'], $_POST['courseName'], $_POST['semester'])) {
        $programme = urlencode($_POST['programme']);
        $course = urlencode($_POST['courseName']);
        $semester = urlencode($_POST['semester']);

        // Redirect to same page with data in query string
        header("Location: {$_SERVER['PHP_SELF']}?programme=$programme&courseName=$course&semester=$semester");
        exit();
    }

    // Step 2: On GET, fetch data if parameters exist
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['programme'], $_GET['courseName'], $_GET['semester'])) {
        $showTable = true;

        $programme = $_GET['programme'];
        $course = $_GET['courseName'];
        $semester = $_GET['semester'];

        // Database connection
        // $conn = new mysqli("localhost", "root", "", "nedacademy");
        // if ($conn->connect_error) {
        //     die("Connection failed: " . $conn->connect_error);
        // }

        include 'db.php';

        $sql = "SELECT CNIC, name, father_name, order_id, amount, tr_status FROM students_table WHERE programme=? AND course_name=? AND semester=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sss", $programme, $course, $semester);
        $stmt->execute();
        $result = $stmt->get_result();

        while ($row = $result->fetch_assoc()) {
            $students[] = $row;
        }

        $stmt->close();
        $conn->close();
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">OLD SEMESTER BLOCK UGD</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>   
                            </div>
                        </div>
                    </div>
                    
                    <div class="container2">
                        <form name="myform" method="POST" action="">
                            <input type="hidden" id="pagename" name="pagename" value="StudentDiscount">   
                            <div style="display: flex; text-align: justify; padding: 50px; gap: 2%;">
                                <div style="width: 33.33%;">
                                    <label class="text">Programme Name</label><br>
                                    <div style="padding-top: 10px">
                                        <!-- FIXED ID HERE -->
                                        <select class="custom-select-cpt" id="programme" name="programme" required>
                                            <option value="">Select</option>
                                            <option value="PGD">PGD</option>
                                            <option value="UGD">UGD</option>
                                        </select>

                                        <script>
                                            document.getElementById('programme').addEventListener('change', function () {
                                                if (this.value === 'PGD') {
                                                    window.location.href = 'OldSemesterBlocK.php';
                                                }
                                            });
                                        </script>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                    <label class="text">Course Name</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-cpt" id="courseName" name="courseName" required>
                                            <option>Select</option>
                                            <option>UGD In Amazon Web Services (AWS) </option>
                                            <option>UGD In Animation, Visual Effect &amp; Multimedia </option>
                                            <option>UGD In Artificial Intelligence </option>
                                            <option>UGD In Automotive Technician </option>
                                            <option>UGD In Chemical Engineering </option>
                                            <option>UGD In Computer Network &amp; System Administration </option>
                                            <option>UGD In Cyber Security Essentials </option>
                                            <option>UGD In Data Analytics </option>
                                            <option>UGD In Data Engineering </option>
                                            <option>UGD In Data Science </option>
                                            <option>UGD In Digital Marketing </option>
                                            <option>UGD In Digital Media </option>
                                            <option>UGD In Digital Media + TV Production </option>
                                            <option>UGD In E-Commerce </option>
                                            <option>UGD In Electrical Engineering (Electrical Power Systems) </option>
                                            <option>UGD In Electronic Engineering And Applied Technologies </option>
                                            <option>UGD In Fashion Design </option>
                                            <option>UGD In Film Production </option>
                                            <option>UGD In Food Science And Technology </option>
                                            <option>UGD In Game Designing And Development Technology </option>
                                            <option>UGD In Generative AI </option>
                                            <option>UGD In Graphics Designing </option>
                                            <option>UGD In Industrial Control &amp; Automation </option>
                                            <option>UGD In Information Technology </option>
                                            <option>UGD In Interior Design </option>
                                            <option>UGD In Marketing, Sales &amp; Distribution Management </option>
                                            <option>UGD In Media Sciences </option>
                                            <option>UGD In Office Administration &amp; Communication </option>
                                            <option>UGD In Photography &amp; Videography  </option>
                                            <option>UGD In Refrigeration &amp; Air Conditioning  </option>
                                            <option>UGD In Software Engineering </option>
                                            <option>UGD In Textile Science &amp; Technology </option>
                                            <option>UGD In Voice Acting/Dubbing </option>
                                        </select>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                    <label class="text">Semester</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-cpt" id="semester" name="semester" required>
                                            <option>Select</option>
                                            <option>Old Semesters</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div style="display: flex; justify-content: center; padding-bottom: 20px; position: relative; top: -10px;">
                                <input type="submit" value="VIEW"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                            </div>
                        </form>
                        <?php if ($showTable): ?>
                            <form action="setadmit" method="POST" onsubmit="return validate(this)">
                                <input type="hidden" name="programe1" value="<?php echo htmlspecialchars($programme); ?>">
                                <input type="hidden" name="yearid1" value="null">
                                <input type="hidden" name="title1" value="57866">
                                <input type="hidden" name="batchno1" value="null">
                                <div style="padding: 50px; padding-top: 0px;">
                                    <table>
                                        <thead>
                                            <tr style="background-color: #a10101; color: white;">
                                                <th>CNIC</th>
                                                <th>Name</th>
                                                <th>Father Name</th>
                                                <th>OrderID</th>
                                                <th>Amount</th>
                                                <th>Tr Status #</th>
                                                <th>Block</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($students)): ?>
                                                <?php foreach ($students as $student): ?>
                                                    <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                                        <td><?= htmlspecialchars($student['CNIC']) ?></td>
                                                        <td><?= htmlspecialchars($student['name']) ?></td>
                                                        <td><?= htmlspecialchars($student['father_name']) ?></td>
                                                        <td><?= htmlspecialchars($student['order_id']) ?></td>
                                                        <td><?= htmlspecialchars($student['amount']) ?></td>
                                                        <td><?= htmlspecialchars($student['tr_status']) ?></td>
                                                        <td><input type="checkbox" name="block[]" value="<?= htmlspecialchars($student['CNIC']) ?>"></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <tr><td colspan="7" style="text-align: center;">No Student record found.</td></tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div style="display: flex; justify-content: center; padding-bottom: 20px; position: relative; top: -10px;">
                                    <input type="submit" value="SUBMIT"
                                        style="background-color: rgb(161, 1, 1); padding: 12px 70px; border-radius: 70px; border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer;" />
                                </div>
                            </form>
                        <?php endif; ?>
                    </div>

                    <!-- Footer -->
                    <div class="container4" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <script>
            // Clear the URL parameters (only once, when page is loaded after redirect)
            if (performance.navigation.type === performance.navigation.TYPE_NAVIGATE || performance.getEntriesByType("navigation")[0].type === "navigate") {
                if (window.location.href.indexOf('?') > -1) {
                    window.history.replaceState({}, document.title, window.location.pathname);
                }
            }
        </script>
    </body>
</html>