<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="dashboard-container">
            <div  style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px;">
                <!-- Header -->
                <div class="container1">
                    <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                        <div class="text-left">
                        <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                        </div>
                        <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: 0; font-family: system-ui; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">PGCC COURSE CHANGE</h2>
                        <div style="display: flex; justify-content: flex-end; padding: 10px;">
                            <button class="logout-btn" style="background: none; border: none;">
                                <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; font-family: system-ui; position: relative; bottom: 21px; right: 10px;">
                                LOGOUT
                                </a>
                            </button>
                        </div>
                        <div style="padding-left: 30px;">
                            <button onclick="window.history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; font-family: system-ui; position: relative; bottom: 60px;">
                                BACK
                            </button>
                        </div>
                    </div>
                </div>

                <div class="container2">
                    <div class="py-3 text-center">          
                        <div class="form-group">
                            <form action="setadmit" method="POST" onsubmit="return validate(this)">
                                <input type="hidden" id="programe1" name="programe1" value="Certificate">
                                <input type="hidden" id="yearid1" name="yearid1" value="null">
                                <input type="hidden" id="title1" name="title1" value="57866">
                                <input type="hidden" id="batchno1" name="batchno1" value="null">
                                <div style="padding: 50px; padding-top: 0px;">
                                    <table>
                                        <thead>
                                        <tr style="background-color: #a10101; color: white;">
                                            <th>Student ID</th>
                                            <th>Name</th>
                                            <th>Father Name</th>
                                            <th>CNIC</th>
                                            <th>Course</th>
                                            <th>Verify</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <!-- Repeat rows dynamically -->
                                        <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td style="padding: 20px;">
                                                <a href="PGCCCourseEdit.php"
                                                    style="background-color: rgba(39, 10, 78, 0.973);padding: 10px 27px;border-radius: 70px;border: transparent;
                                                    color: white;font-family: system-ui;font-weight: bolder;cursor: pointer; text-decoration: none;">COURSE CHANGE</a>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </form>
                        </div>      
                    </div>
                </div>
                
                <!-- Footer -->
                <div class="container4" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                    <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                        <span style="color: white; font-weight: 600; ">
                        © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                        </span>
                    </p>
                </div>
            </div>
         </div>
    </body>
</html>