<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="dashboard-container">
            <div  style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px;">
                <!-- Header -->
                <div class="container1">
                    <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                        <div class="text-left">
                        <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                        </div>
                        <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: 0; font-family: system-ui; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">PGCC COURSE TRANSFER INFORMATION </h2>
                        <div style="display: flex; justify-content: flex-end; padding: 10px;">
                            <button class="logout-btn" style="background: none; border: none;">
                                <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; font-family: system-ui; position: relative; bottom: 21px; right: 10px;">
                                LOGOUT
                                </a>
                            </button>
                        </div>
                        <div style="padding-left: 30px;">
                            <button onclick="window.history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; font-family: system-ui; position: relative; bottom: 60px;">
                                BACK
                            </button>
                        </div>
                    </div>
                </div>

                <div class="container2" style="padding: 70px;">
                    <div style="display: flex; gap: 2%; padding-bottom: 20px;">
                        <div style="width: 50%;">
                            <input type="hidden" name="stdid" id="stdid" value="300071">
                            <input type="hidden" name="psid" id="psid" value="549">
                            <label for="exampleInputEmail1" class="text"><span style="color: Red; font-size: medium;">*</span>&nbsp;Department</label>
                            <select class="custom-select" id="dept" name="dept" onclick="clearBox();" onchange="showState(this.value);">  
                                <option value="0">Select</option>
                                <option value="12">Department of Architecture </option>
                                <option value="36">Department of Automotive and Marine Engineering</option>
                                <option value="42">Department of Bio-Medical Engineering</option>
                                <option value="90">Department of Chemical Engineering</option>
                                <option value="45">Department of Chemistry</option>
                                <option value="1">Department of Civil Engineering</option>
                                <option value="5">Department of Computer &amp; Informations  Systems Engineering</option>
                                <option value="10">Department of Computer Science and Information Technology</option>
                                <option value="112">Department of Earthquake Engineering</option>
                                <option value="122">Department of Economics and Management Sciences</option>
                                <option value="3">Department of Electrical Engineering</option>
                                <option value="7">Department of Electronic Engineering</option>
                                <option value="81">Department of English Linguistics &amp; Allied Studies</option>                       
                                <option value="4">Department of Environmental Engineering</option>                        
                                <option value="8">Department of Industrial  &amp; Manufacturing Engineering</option>                       
                                <option value="99">Department of Materials Engineering</option>                       
                                <option value="9">Department of Mathematics</option>                       
                                <option value="2">Department of Mechanical Engineering</option>                      
                                <option value="109">Department of Metallurgical Engineering</option>                     
                                <option value="37">Department of Petroleum Engineering</option>                    
                                <option value="44">Department of Physics</option>                  
                                <option value="101">Department of Polymer and Petrochemical Engineering</option>                  
                                <option value="123">Department of Software Engineering</option>                 
                                <option value="51">Department of Telecommunications Engineering</option>                      
                                <option value="6">Department of Textile Engineering</option>                       
                                <option value="108">Department of Urban and Infrastructure Engineering</option>                       
                                <option value="147">Panjwani-Hisaar Water Institute (PHWI)</option>
                            </select>
                        </div>
                            
                        <div style="width: 50%;">
                            <label for="exampleInputEmail1" class="text"><span style="color:Red; font-size:medium;">*</span>&nbsp;Programme</label>
                            <select class="custom-select " id="prog" name="prog" onclick="clearBox();" onchange="showprog(this.value);">
                                <option value="0">Select</option>
                            </select>
                        </div>
                    </div>

                    <div style="display: flex; gap: 2%; padding-bottom: 20px;">
                        <div style="width: 50%;">
                            <label for="exampleInputEmail1" class="text"><span style="color:Red; font-size:medium;">*</span>&nbsp;Field Of Specialization</label>
                            <select class="custom-select d-block w-100" id="depfos" name="depfos" onclick="clearBox();" onchange="showprogtype(this.value);  ">
                                <option value="0">Select</option>
                            </select>
                        </div>

                        <div style="width: 50%;">
                            <label for="exampleInputEmail1" class="text"><span style="color:Red; font-size:medium;">*</span>&nbsp;Programme Type</label>
                            <select class="custom-select d-block w-100" id="tick" name="tick" onclick="clearBox();" onchange="showcourse(this.value);  ">
                                <option value="0">Select</option>
                            </select>
                        </div>
                    </div>
                    
                    <div style="padding-bottom: 20px;">
                        <label for="exampleInputEmail1" class="text"><span style="color:Red; font-size:medium;">*</span>&nbsp;Course Code &amp; Title</label>  
                        <select class="custom-select d-block w-100" id="course1" name="course1" style="width:100.0%;" onclick="clearBox();">
                            <option value="0">Select</option>
                        </select>  
                    </div>
                    <div style="text-align: center; position: relative; top: 20px;">
                        <a href="PGCCCourseChangeList.php" type="Submit" style="background-color: rgb(161, 1, 1); padding: 15px 65px; border-radius: 26px; border: transparent; color: white; 
                        font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none;">UPDATE</a>
                    </div>
                </div>
                
                <!-- Footer -->
                <div class="container4" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                    <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                        <span style="color: white; font-weight: 600; ">
                        © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                        </span>
                    </p>
                </div>
            </div>
         </div>
    </body>
</html>