<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="dashboard-container">
            <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px;">
                <div class="container1">
                    <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                        <div class="py-2 text-left">
                            <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                        </div>
                        <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">PAYMENT DETAILS</h2>
                        <div style="display: flex; justify-content: flex-end; padding: 10px;">
                            <button class="logout-btn" style="background: none; border: none;">
                                <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                    LOGOUT
                                </a>
                            </button>
                        </div>
                        <div style="padding-left: 30px;">
                            <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                BACK
                            </button>
                        </div> 
                    </div>
                </div>

                <div class="container2">
                    <form method="POST" action="addpayment">
                        <div style="text-align: center">
                            <label for="paidto" class="text">VoucherNo :</label>
                            &nbsp;&nbsp;&nbsp; 
                            <label for="paidto" style="color:Maroon; font-weight:bold;">000001</label>
                        </div>

                        <div style="display: flex; gap: 2%; margin-left: 50px; margin-right: 50px; padding-top: 30px;">
                            <div>
                                <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px">Paid To</label>
                                <select id="ahead" name="ahead" onkeypress="clearBox();" class="custom-select"  required="">
                                    <option value="0">Select</option>
                                </select>
                            </div>

                            <div>
                                <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px">* Payment Date</label>
                                <input type="date" class="custom-select" required="">
                            </div>
                                
                            <div>
                                <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px">Paid Detail</label>
                                <select id="sahead" name="sahead" onkeypress="clearBox();" class="custom-select" required="">
                                    <option value="0">Select</option>                                            
                                </select>
                            </div>
                                                    
                            <div>
                                <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px">Voucher Type</label>
                                <select id="vno" name="vno" onkeypress="clearBox();" class="custom-select" required="">
                                    <option value="0">Select</option>    
                                    <option value="Remuneration">Remuneration</option>
                                    <option value="Impreset">Impreset</option>
                                </select>
                            </div>

                            <div>
                                <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px">Payment Type</label>
                                <select id="vno" name="vno" onkeypress="clearBox();" class="custom-select" required="">
                                    <option value="0">Select</option>
                                    <option value="1">Gross</option>
                                    <option value="2">Income Tax Deduction</option>
                                    <option value="3">GST Tax</option>
                                    <option value="4">SST Tax</option>
                                    <option value="5">Net Amount Deduction</option>
                                </select>
                            </div>

                            <div>
                                <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px">Paid Amount</label>
                                <input id="vno" name="vno" placeholder="XXXXXXXX" onkeypress="clearBox();" class="custom-select" required="">
                            </div>
                        </div>
                        <div style="text-align: center; padding-top: 40px; padding-bottom: 10px;">
                            <input type="submit" value="ADD ROW"
                                style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                        </div>
                    </form>
                    <div class="container-fluid" style="padding-top: 30px; margin-left: 40px;">
                        <form action="paymentdeletepage" method="post">
                            <div style="display: flex; gap: 3%;">
                                <div>
                                    <input type="hidden" name="bdid2" id="bdid2">
                                    <input type="hidden" name="paidid" id="paidid">
                                    <input type="hidden" name="bdid" id="bdid">
                                    <input type="text" placeholder="Name" name="paidto[]" id="paidto" class="custom-select" style="width: 110%">
                                </div>           
                                <div>
                                    <input type="text" placeholder="Payment Date" name="DETAIL_DATE[]" id="DETAIL_DATE" class="custom-select" style="width: 110%">
                                </div>           
                                <div>
                                    <input type="text" placeholder="Paid Detail" name="DETAIL[]" id="DETAIL" class="custom-select" style="width: 110%">
                                </div>           
                                <div>
                                    <input type="text" placeholder="Payment Type" name="taxid[]" id="taxid" class="custom-select" style="width: 110%">
                                </div>           
                                <div>
                                    <input type="text" placeholder="Paid Amount" name="PAIDAMOUNT[]" id="PAIDAMOUNT" class="custom-select" style="width: 110%">
                                </div>
                                <div style="text-align: center; padding-bottom: 10px; position: relative; top: -3px">
                                    <input type="submit" value="DELETE"
                                        style="background-color: rgba(39, 10, 78, 0.973); padding: 10px 27px; border-radius: 70px; 
                                            border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;">
                                </div>    
                            </div>  
                        </form>     
                        <form action="paymentdeletepage" method="post">
                            <div style="display: flex; gap: 3%">
                                <div>
                                    <input type="hidden" name="bdid2" id="bdid2">
                                    <input type="hidden" name="paidid" id="paidid">
                                    <input type="hidden" name="bdid" id="bdid">
                                    <input type="text" placeholder="Name" name="paidto[]" id="paidto" class="custom-select" style="width: 110%">
                                </div>           
                                <div >
                                    <input type="text" placeholder="Payment Date" name="DETAIL_DATE[]" id="DETAIL_DATE" class="custom-select" style="width: 110%">
                                </div>           
                                <div>
                                    <input type="text" placeholder="Paid Detail" name="DETAIL[]" id="DETAIL" class="custom-select" style="width: 110%">
                                </div>           
                                <div>
                                    <input type="text" placeholder="Payment Type" name="taxid[]" id="taxid" class="custom-select" style="width: 110%">
                                </div>             
                                <div>
                                    <input type="text" placeholder="Paid Amount" name="PAIDAMOUNT[]" id="PAIDAMOUNT" class="custom-select" style="width: 110%">
                                </div>
                                <div style="text-align: center; padding-bottom: 10px; position: relative; top: -3px">
                                    <input type="submit" value="DELETE"
                                        style="background-color: rgba(39, 10, 78, 0.973); padding: 10px 27px; border-radius: 70px; 
                                            border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;">
                                </div>     
                            </div>   
                        </form>    
                        <form action="paymentdeletepage" method="post">
                            <div style="display: flex; gap: 3%">
                                <div>
                                    <input type="hidden" name="bdid2" id="bdid2">
                                    <input type="hidden" name="paidid" id="paidid">
                                    <input type="hidden" name="bdid" id="bdid">
                                    <input type="text" placeholder="Name" name="paidto[]" id="paidto" class="custom-select" style="width: 110%">
                                </div>           
                                <div>
                                    <input type="text" placeholder="Payment Date" name="DETAIL_DATE[]" id="DETAIL_DATE" class="custom-select" style="width: 110%">
                                </div>           
                                <div>
                                    <input type="text" placeholder="Paid Detail" name="DETAIL[]" id="DETAIL" class="custom-select" style="width: 110%">
                                </div>           
                                <div>
                                    <input type="text" placeholder="Payment Type" name="taxid[]" id="taxid" class="custom-select" style="width: 110%">
                                </div>            
                                <div>
                                    <input type="text" placeholder="Paid Amount" name="PAIDAMOUNT[]" id="PAIDAMOUNT" class="custom-select" style="width: 110%">
                                </div>
                                <div style="text-align: center; padding-bottom: 10px; position: relative; top: -3px">
                                    <input type="submit" value="DELETE"
                                        style="background-color: rgba(39, 10, 78, 0.973); padding: 10px 27px; border-radius: 70px; 
                                            border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;">
                                </div>    
                            </div>  
                        </form>
                    </div>
                    <div style="display: flex; gap: 2%; margin-left: 50px; padding-top: 40px;">
                        <div>
                            <label for="exampleInputEmail1" style="color:Blue; font-size:large;">Gross Total Amount</label>
                        </div>            
                        <div>
                            <label style="color:Red; font-size:x-large; font-weight:bold;">0</label>   
                        </div>            
                        <div>
                            <label for="exampleInputEmail1" style="color:Blue; font-size:large;">IncomeTax Total Amount</label>   
                        </div> 
                        <div>
                            <label style="color:Red; font-size:x-large; font-weight:bold;">0 </label>   
                        </div>         
                        <div>
                            <label for="exampleInputEmail1" style="color:Blue; font-size:large;">SST TAX</label>   
                        </div> 
                        <div>
                            <label style="color:Red; font-size:x-large; font-weight:bold;">0 </label>  
                        </div> 
                        <div>
                            <label for="exampleInputEmail1" style="color:Blue; font-size:large;">Net Total Amount</label>   
                        </div> 
                        <div>
                            <label style="color:Red; font-size:x-large; font-weight:bold;">0</label>  
                        </div> 
                    </div>
                </div>

                 <!-- Footer -->
                <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                    <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                        <span style="color: white; font-weight: 600; ">
                            © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                        </span>
                    </p>
                </div>
            </div>
        </div>
        <script>
            // Clear the URL parameters (only once, when page is loaded after redirect)
            if (performance.navigation.type === performance.navigation.TYPE_NAVIGATE || performance.getEntriesByType("navigation")[0].type === "navigate") {
                if (window.location.href.indexOf('?') > -1) {
                    window.history.replaceState({}, document.title, window.location.pathname);
                }
            }
        </script>
    </body>
</html>