<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();

    // Handle POST request only once and redirect
    $showTable = false;
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $_SESSION['form_data'] = $_POST;
        $_SESSION['showTable'] = true;
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }

    // After redirect, show table if flag is set
    if (isset($_SESSION['showTable']) && $_SESSION['showTable'] === true) {
        $showTable = true;
        unset($_SESSION['showTable']); // reset the flag
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">PAYMENTS</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <form method="POST" action="">
                            <div style="display: flex; justify-content: space-around; margin-left: 20px; margin-right: 20px; padding-top: 30px;">
                                <script>
                                    $( function() {
                                    var maxYear = new Date().getFullYear();
                                    var minYear = maxYear - 1;
                                    $( "#dob1" ).datepicker({
                                        changeMonth: true,
                                        changeYear: true,
                                        //maxDate: '2',
                                        autoclose:true,
                                        dateFormat: 'dd-M-yy',   
                                        yearRange: (minYear + ':' + maxYear),
                                        readonly:'true',
                                        onClose: function(dateText, inst) {
                                            $(this).datepicker('option', 'dateFormat', 'dd-M-yy');                
                                        }
                                        });
                                        // $("#dob1").keydown(false);
                                        // .datepicker({yearRange: "1970:+nn"});
                                        $("#dob1").keypress(function(event) {
                                            return ( ( event.keyCode || event.which ) === 9 ? true : false );
                                        });
                                    //}).attr('readonly','true');
                                    // }).attr("disabled","disabled");
                                    } );
                                </script>
                        
                                <script>
                                    $( function() {
                                        $( "#pdate" ).datepicker({
                                            changeMonth: true,
                                            changeYear: true,
                                            maxDate: '2',
                                            autoclose:true,
                                            dateFormat: 'dd-M-y',    
                                            // yearRange: '-99:-18'
                                            //   yearRange: "1950:+nn",
                                            yearRange: "2021:+nn",
                                            readonly:'true',
                                            onClose: function(dateText, inst) {
                                                $(this).datepicker('option', 'dateFormat', 'dd-M-y');                
                                            }
                                        });
                                        // $("#dob1").keydown(false);
                                        // .datepicker({yearRange: "1970:+nn"});
                                        $("#pdate").keypress(function(event) {
                                            return ( ( event.keyCode || event.which ) === 9 ? true : false );
                                        });
                                        //}).attr('readonly','true');
                                        // }).attr("disabled","disabled");
                                    } );
                                </script>

                                <div>
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;">Payment Date</label>
                                    <!--<input type="text" name="pdate" id="pdate" class="form-control"  readonly="readonly"  value="29-05-2025">!-->
                                    <input type="date" name="pdate" id="pdate" class="custom-select" required="">
                                </div>

                                <div>
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;">Head of Account</label>
                                    <select id="ahead" name="ahead" onkeypress="clearBox();" class="custom-select"  required="">
                                        <option value="0" selected="selected">Select</option>
                                        <option value="4">Advertisement &amp; Publicity </option>
                                        <option value="12">Certificate Refund </option>
                                        <option value="5">Entertainment </option>
                                        <option value="9">Expected Closing Balance </option>
                                        <option value="8">Expected Investment </option>
                                        <option value="2">Furniture &amp; Fixture </option>
                                        <option value="1">Machinery &amp; Equipment </option>
                                        <option value="13">PGCC Refund </option>
                                        <option value="11">PGD Refund </option>
                                        <option value="15">PITP </option>
                                        <option value="3">Printing &amp; Stationary </option>
                                        <option value="14">Registrar Office Payments </option>
                                        <option value="7">Resource Person </option>
                                        <option value="16">Service Charges </option>
                                        <option value="10">UGD Refund </option>
                                        <option value="6">Unforeseen Expenses </option>
                                    </select>
                                </div>
                            
                                <div>
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;">Sub Head of Account</label>
                                    <select id="sahead" name="sahead" onkeypress="clearBox();" class="custom-select" required="">
                                        <option value="0" selected="selected">Select</option>                                            
                                        <option value="4">Advertisement &amp; Publicity </option>
                                        <option value="12">Certificate Refund </option>
                                        <option value="5">Entertainment </option>
                                        <option value="9">Expected Closing Balance </option>
                                        <option value="8">Expected Investment </option>
                                        <option value="2">Furniture &amp; Fixture </option>
                                        <option value="1">Machinery &amp; Equipment </option>
                                        <option value="13">PGCC Refund </option>
                                        <option value="11">PGD Refund </option>
                                        <option value="15">PITP </option>
                                        <option value="3">Printing &amp; Stationary </option>
                                        <option value="14">Registrar Office Payments </option>
                                        <option value="7">Resource Person </option>
                                        <option value="16">Service Charges </option>
                                        <option value="10">UGD Refund </option>
                                        <option value="6">Unforeseen Expenses </option>
                                    </select>
                                </div>
                                                
                                <div>
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;">Voucher No</label>
                                    <select id="vno" name="vno" onkeypress="clearBox();" class="custom-select" required="">
                                        <option>Select</option>
                                        <option value="A">A</option>
                                        <option value="B">B</option>
                                        <option value="C">C</option>
                                        <option value="D">D</option>
                                        <option value="E">E</option>
                                        <option value="F">F</option>
                                        <option value="G">G</option>
                                        <option value="H">H</option>
                                        <option value="I">I</option>
                                        <option value="J">J</option>
                                        <option value="K">K</option>
                                        <option value="L">L</option>
                                        <option value="M">M</option>
                                        <option value="N">N</option>
                                        <option value="O">O</option>
                                        <option value="P">P</option>
                                        <option value="Q">Q</option>
                                        <option value="R">R</option>
                                        <option value="S">S</option>
                                        <option value="T">T</option>
                                        <option value="U">U</option>
                                        <option value="V">V</option>
                                        <option value="W">W</option>
                                        <option value="X">X</option>
                                        <option value="Y">Y</option>
                                        <option value="Z">Z</option>
                                    </select>
                                </div>
                            </div>
                                
                            <div style="text-align: center; padding-top: 40px; padding-bottom: 10px;">
                                <input type="submit" value="ADD ROW"
                                style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                            </div>
                        </form>

                        <?php if ($showTable): ?>
                            <form action="setadmit" method="POST" onsubmit="return validate(this)">
                                <input type="hidden" id="programe1" name="programe1" value="Certificate">
                                <input type="hidden" id="yearid1" name="yearid1" value="null">
                                <input type="hidden" id="title1" name="title1" value="57866">
                                <input type="hidden" id="batchno1" name="batchno1" value="null">
                                <div style="padding: 50px; padding-top: 0px;">
                                    <table>
                                        <thead>
                                            <tr style="background-color: #a10101; color: white;">
                                                <th>Payment Date</th>
                                                <th>Head of Account</th>
                                                <th>Voucher No</th>
                                                <th>Voucher No</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Repeat rows dynamically -->
                                            <?php
                                                $formData = $_SESSION['form_data'] ?? [];
                                                $pdate = $formData['pdate'] ?? '';
                                                $ahead = $formData['ahead'] ?? '';
                                                $sahead = $formData['sahead'] ?? '';
                                                $vno = $formData['vno'] ?? '';
                                            ?>
                                            <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                                <td>
                                                    <input type="text" name="PAYMENTDATE[]" value="<?php echo htmlspecialchars($pdate); ?>" style="width:100%; border: none; text-align: center;">
                                                </td>
                                                <td>
                                                    <input type="text" name="HEAD_ACCOUNT[]" value="<?php echo htmlspecialchars($ahead); ?>" style="width:100%; border: none; text-align: center;">
                                                </td>
                                                <td>
                                                    <input type="text" name="SUB_HEAD_ACCOUNT[]" value="<?php echo htmlspecialchars($sahead); ?>" style="width:100%; border: none; text-align: center;">
                                                </td>
                                                <td>
                                                    <input type="text" name="VOUCHER_NO[]" value="<?php echo htmlspecialchars($vno); ?>" style="width:100%; border: none; text-align: center;">
                                                </td>
                                                <td style="background: none; border: none">
                                                    <a href="PaymentDetails.php" onclick="openDetailPage('599')" style="background-color: rgba(39, 10, 78, 0.973); padding: 10px 27px; border-radius: 70px; 
                                                        border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;">
                                                        Details
                                                    </a>
                                                </td>
                                                <td style="background: none; border: none">
                                                    <a>
                                                        <input type="button" value="Payment Voucher" style="background-color: #a10101; padding: 10px 27px; border-radius: 70px; 
                                                        border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;" id="payment" name="payment">
                                                    </a>
                                                </td>
                                                <td style="background: none; border: none">
                                                    <a>
                                                        <input type="button" value="IncomeTax List" style="background-color: #a10101; padding: 10px 27px; border-radius: 70px; 
                                                        border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;" id="tax" name="tax">
                                                    </a>
                                                </td>
                                                <td style="background: none; border: none">
                                                    <a>
                                                        <input type="button" value="Voucher List" style="background-color: #a10101; padding: 10px 27px; border-radius: 70px; 
                                                        border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;" id="voucher" name="voucher">
                                                    </a>
                                                </td>
                                                <td style="background: none; border: none">
                                                    <a>
                                                        <input type="button" value="Bank List" style="background-color: #a10101; padding: 10px 27px; border-radius: 70px; 
                                                        border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer; text-decoration: none; width: 100%;" id="voucher" name="voucher">
                                                    </a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </form>
                        <?php endif; ?>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <script>
            // Clear the URL parameters (only once, when page is loaded after redirect)
            if (performance.navigation.type === performance.navigation.TYPE_NAVIGATE || performance.getEntriesByType("navigation")[0].type === "navigate") {
                if (window.location.href.indexOf('?') > -1) {
                    window.history.replaceState({}, document.title, window.location.pathname);
                }
            }
        </script>
    </body>
</html>