<?php
    session_start();

    // Reset session data manually with ?reset=true
    if (isset($_GET['reset'])) {
        unset($_SESSION['programme_name']);
        unset($_SESSION['course_name']);
        unset($_SESSION['cnic']);
        unset($_SESSION['students']);
        header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
        exit();
    }

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();

    // DB connection
    // $conn = new mysqli("localhost", "root", "", "nedacademy");
    // if ($conn->connect_error) {
    //     die("Connection failed: " . $conn->connect_error);
    // }

    include 'db.php';

    // Fetch certificate list
    $certificates = [];
    $cert_result = $conn->query("SELECT id, certificate_name FROM certificates ORDER BY certificate_name ASC");
    if ($cert_result) {
        while ($row = $cert_result->fetch_assoc()) {
            $certificates[] = $row;
        }
    }

    // Handle form submission and redirect
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['course']) && isset($_POST['cnic'])) {
        $course = $conn->real_escape_string($_POST['course']);
        $cnic = $conn->real_escape_string($_POST['cnic']);

        $query = "SELECT programme_name, course_name, cnic, transferred_to, transfer_date 
                  FROM programme_transfer 
                  WHERE certificate_id = '$selectedCertificateId' AND cnic = '$cnic'";
        $result = $conn->query($query);

        $students = [];
        if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $students[] = $row;
            }
        }

        $_SESSION['programme_name'] = $programme_name;
        $_SESSION['course_name'] = $course;
        $_SESSION['cnic'] = $cnic;
        $_SESSION['students'] = $students;

        // Redirect to avoid form resubmission warning
        header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
        exit();
    }

    // Populate values after redirect
    $programme_name = $_SESSION['programme_name'] ?? '';
    $course = $_SESSION['course_name'] ?? '';
    $cnic = $_SESSION['cnic'] ?? '';
    $students = $_SESSION['students'] ?? [];

    // Clear after display (optional because i may have to remove it in future)
    unset($_SESSION['programme_name']);
    unset($_SESSION['course_name']);
    unset($_SESSION['cnic']);
    unset($_SESSION['students']);
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">PROGRAMME TRANSFER FROM PGD</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                    <form name="myform" method="POST" action="searchvalues">
                            <input type="hidden" id="pagename" name="pagename" value="StudentDiscount">   
                            <div style="display: flex; text-align: justify; padding: 50px; gap: 2%;">
                                <div style="width: 33.33%;">
                                    <label class="text">Programme Name</label><br>
                                    <div style="padding-top: 10px">
                                        <!-- FIXED ID HERE -->
                                        <select class="custom-select-cpt" id="programme" name="programme" required>
                                            <option value="">Select</option>
                                            <option value="PGD">PGD</option>
                                            <option value="UGD">UGD</option>
                                        </select>

                                        <!-- JavaScript inside or below form -->
                                        <script>
                                            document.getElementById('programme').addEventListener('change', function () {
                                                if (this.value === 'UGD') {
                                                    window.location.href = 'ProgrammeTransferUGD.php';
                                                }
                                            });
                                        </script>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                    <label class="text">Course Name</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-cpt" id="courseName" name="courseName" required>
                                            <option value="Select">Select</option>
                                            <option value="PGD In Devops">PGD In Devops </option>
                                            <option value="PGD In Industrial Safety And Environmental Engineering">PGD In Industrial Safety And Environmental Engineering </option>
                                            <option value="PGD In Islamic Banking And Finance">PGD In Islamic Banking &amp; Finance </option>
                                            <option value="PGD in Accounting And Finance">PGD in Accounting And Finance </option>
                                            <option value="PGD in Advanced English Language Teaching">PGD in Advanced English Language Teaching </option>
                                            <option value="PGD in Animation And Gaming">PGD in Animation And Gaming </option>
                                            <option value="PGD in Block Chain Technology">PGD in Block Chain Technology </option>
                                            <option value="PGD in Business Economics">PGD in Business Economics </option>
                                            <option value="PGD in Business Leadership">PGD in Business Leadership </option>
                                            <option value="PGD in Business Management">PGD in Business Management </option>
                                            <option value="PGD in Chemical Engineering">PGD in Chemical Engineering </option>
                                            <option value="PGD in Cloud Computing">PGD in Cloud Computing </option>
                                            <option value="PGD in Cloud-Based IoT And Edge Computing">PGD in Cloud-Based IoT And Edge Computing </option>
                                            <option value="PGD in Computational Mathematics">PGD in Computational Mathematics  </option>
                                            <option value="PGD in Computational Science And Engineering">PGD in Computational Science And Engineering </option>
                                            <option value="PGD in Construction Cost Engineering">PGD in Construction Cost Engineering </option>
                                            <option value="PGD in Construction Management">PGD in Construction Management </option>
                                            <option value="PGD in Corpus Linguistics">PGD in Corpus Linguistics </option>
                                            <option value="PGD in Cyber Security">PGD in Cyber Security </option>
                                            <option value="PGD in Data Science With Artificial Intelligence (AI)">PGD in Data Science With Artificial Intelligence (AI) </option>
                                            <option value="PGD in Denim Manufacturing And Merchandising">PGD in Denim Manufacturing &amp; Merchandising </option>
                                            <option value="PGD in Electrical Power Systems">PGD in Electrical Power Systems </option>
                                            <option value="PGD in Energy Management">PGD in Energy Management </option>
                                            <option value="PGD in Food Processing">PGD in Food Processing </option>
                                            <option value="PGD in Food Supply Chain Management">PGD in Food Supply Chain Management </option>
                                            <option value="PGD in Garment Manufacturing">PGD in Garment Manufacturing </option>
                                            <option value="PGD in Generative AI">PGD in Generative AI </option>
                                            <option value="PGD in Human Resource Management">PGD in Human Resource Management </option>
                                            <option value="PGD in Industrial Chemistry">PGD in Industrial Chemistry </option>
                                            <option value="PGD in Industrial Psychology And Organizational Behaviour">PGD in Industrial Psychology And Organizational Behaviour </option>
                                            <option value="PGD in Industrial Relations And Labor Laws">PGD in Industrial Relations And Labor Laws </option>
                                            <option value="PGD in Industrial Water Treatment">PGD in Industrial Water Treatment </option>
                                            <option value="PGD in Insurance And Risk Management">PGD in Insurance &amp; Risk Management </option>
                                            <option value="PGD in Marketing Management">PGD in Marketing Management </option>
                                            <option value="PGD in Mechatronics">PGD in Mechatronics </option>
                                            <option value="PGD in Metaverse User Experience Design">PGD in Metaverse User Experience Design </option>
                                            <option value="PGD in Mind Sciences And Mind Engineering">PGD in Mind Sciences And Mind Engineering </option>
                                            <option value="PGD in Occupational Health And Safety">PGD in Occupational Health And Safety </option>
                                            <option value="PGD in Pharmaceutical Engineering">PGD in Pharmaceutical Engineering </option>
                                            <option value="PGD in Polymer Technology">PGD in Polymer Technology </option>
                                            <option value="PGD in Procurement, Contracts And Laws">PGD in Procurement, Contracts And Laws </option>
                                            <option value="PGD in Production Management">PGD in Production Management </option>
                                            <option value="PGD in Project Management">PGD in Project Management </option>
                                            <option value="PGD in Renewable Energy">PGD in Renewable Energy </option>
                                            <option value="PGD in Software Engineering">PGD in Software Engineering </option>
                                            <option value="PGD in Supply Chain Management">PGD in Supply Chain Management </option>
                                            <option value="PGD in Sustainable Engineering">PGD in Sustainable Engineering </option>
                                            <option value="PGD in Textile Management">PGD in Textile Management </option>
                                            <option value="PGD in Textile Merchandising">PGD in Textile Merchandising  </option>
                                            <option value="PGD in Total Quality Management">PGD in Total Quality Management </option>
                                        </select>
                                    </div>
                                </div>

                                <div style="width: 33.33%;">
                                <label class="text" >CNIC</label><br>
                                    <div style="padding-top: 10px">
                                        <input class="custom-select-cpt" type="number" placeholder="XXXXXXXXXXXXX" id="cnic" name="cnic" required="" >
                                    </div>
                                </div>
                            </div>

                            <div style="display: flex; justify-content: center; padding-bottom: 20px; position: relative; top: -10px;">
                                <input type="submit" value="VIEW"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                            </div>
                        </form>
                        <form action="setadmit" method="POST" onsubmit="return validate(this)">
                            <input type="hidden" id="programe1" name="programe1" value="Certificate">
                            <input type="hidden" id="yearid1" name="yearid1" value="null">
                            <input type="hidden" id="title1" name="title1" value="57866">
                            <input type="hidden" id="batchno1" name="batchno1" value="null">
                            <div style="padding: 50px; padding-top: 0px;">
                                <table>
                                    <thead>
                                    <tr style="background-color: #a10101; color: white;">
                                        <th>Student ID</th>
                                        <th>Name</th>
                                        <th>Father Name</th>
                                        <th>CNIC</th>
                                        <th>Programme</th>
                                        <th>Semester</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <!-- Repeat rows dynamically -->
                                    <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </form>
                        <form action="setadmit" method="POST" onsubmit="return validate(this)">
                                <div style="display: flex; justify-content: space-between; padding: 50px; padding-top: 0px;">
                                    <div style="width: 20%;">
                                    <span style="color: #a10101; font-size:medium; font-weight:bold;">Transfer To: </span>
                                    </div>
                                    <div style="width: 80%;">
                                        <label class="text"><span style="color:Red; font-size:medium;">*</span>&nbsp;Programme Name</label>
                                        <select onclick="selOpt()" class="custom-select d-block w-100" id="programmez" name="programmez" onchange="return jsFunctionnew(this);">
                                            <option value="0" selected="selected">Select</option>
                                            <option value="3">Certificate </option>
                                            <option value="1">PGD </option>
                                            <option value="2">UGD </option>
                                        </select>

                                        <!-- JavaScript inside or below form -->
                                        <script>
                                            document.getElementById('programmez').addEventListener('change', function () {
                                                if (this.value === '3') {
                                                    window.location.href = 'ProgrammeTransferPGDToCertificates.php';
                                                }
                                            });
                                            document.getElementById('programmez').addEventListener('change', function () {
                                                if (this.value === '2') {
                                                    window.location.href = 'ProgrammeTransferPGDToUGD.php';
                                                }
                                            });
                                            document.getElementById('programmez').addEventListener('change', function () {
                                                if (this.value === '1') {
                                                    window.location.href = 'ProgrammeTransferPGDToPGD.php';
                                                }
                                            });
                                        </script>
                                    </div>
                                </div>
                            </form>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>