<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">SET USER ACCESS</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <form method="POST" action="useraccess">                   
                            <div class="container-fluid">
                                <div id="demo3" style="border-color:Black; border-style:inset; border-width:0px; color:Red; font-size:medium; font-weight:bold;" align="center"></div>   
                                    <div>   
                                        <div style="padding-top: 30px; margin-left: 30px; margin-right: 30px;">
                                            <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px"> Page Name</label>
                                            <select id="pagename" name="pagename" class="custom-select-course-name" onkeypress="clearBox();" style="width:100.0%;" required="">
                                                <option value="0">Select</option>   
                                                <option>PGD (New)</option>  
                                                <option>UGD (New)</option>  
                                                <option>Bonified Certificates</option>  
                                                <option>Registration List For PGD / UGD</option>  
                                                <option>Attendance List For PGD / UGD</option>  
                                                <option>Declined Student List For PGD / UGD</option>  
                                                <option>Generate Old Vouchers (PGD)</option>      
                                                <option>Generate Old Vouchers (UGD)</option>  
                                                <option>PGD / UGD Forms</option>  
                                                <option>Old Semester Vouchers (Second Time)</option>  
                                                <option>Elective Course Voucher</option>  
                                                <option>Update Student Info & Mode Transfer</option>  
                                                <option>Add Fee Type</option>  
                                                <option>Envelope Report</option>  
                                                <option>Admitted Student List</option>  
                                                <option>Student Cards</option>  
                                                <option>Student Declined For PGD / UGD</option>  
                                                <option>Programme Transfer For PGD / UGD</option>  
                                                <option>Generate CSV File</option>  
                                                <option>Nominee Fees Paid For Certificate</option>  
                                                <option>Add Certificate / Short Courses</option>  
                                                <option>Certificate Programme Transfer</option>  
                                                <option>Generate Old Vouchers For Certificate</option>  
                                                <option>Verify Student Discount For Certificate</option>  
                                                <option>Certificate Cards</option>  
                                                <option>Attendance List For Certificate</option>  
                                                <option>Registration List For Certificate</option>  
                                                <option>Update Student Info For Certificate</option>  
                                                <option>Add PGCC Dates</option> 
                                                <option>Decline Student For PGCC</option>  
                                                <option>Registration Forms Of PGCC</option> 
                                                <option>Verify Student For PGCC</option> 
                                                <option>Registration List For PGCC</option> 
                                                <option>PGCC Cards</option> 
                                                <option>Change Course For PGCC</option> 
                                                <option>Fee Reports</option> 
                                                <option>Receipt Vouchers</option> 
                                                <option>Non PayPro Receipt</option> 
                                                <option>Non PayPro Date Set</option> 
                                                <option>Non PayPro Amount</option> 
                                                <option>Budget Heads</option> 
                                                <option>Budget Allocation</option> 
                                                <option>Budget Head Categories</option> 
                                                <option>Cheque No Entry</option> 
                                                <option>Add Paid To</option> 
                                                <option>Payments</option> 
                                                <option>Allocation List</option> 
                                                <option>Cheque Release / Not</option> 
                                                <option>Old Payment Entry</option> 
                                                <option>Cheque Print</option> 
                                                <option>Ledger</option> 
                                                <option>Cash Book</option> 
                                                <option>Teacher Course Assign</option> 
                                                <option>Student Attendance</option> 
                                                <option>Attendance Report</option> 
                                                <option>Add User / User Access</option> 
                                                <option>Marketing Page</option> 
                                                <option>Student Fee Discount</option> 
                                                <option>Old Semester Block</option> 
                                            </select>
                                        </div>
                                    </div>           
                                </div>    
                                <div style="display: flex; justify-content: center; padding-bottom: 20px; padding-bottom: 50px; padding-top: 50px;">
                                    <input type="submit" value="VIEW" style="background-color: rgb(161, 1, 1); padding: 12px 70px; border-radius: 70px; border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer;">
                                </div>
                                <div style="display: flex; margin-left: 42px; padding-bottom: 40px; gap: 2%;">
                                    <div style="width: 85%;">
                                        <input type="text" class="custom-select-course-name" placeholder="Page Name" name="PAGE_NAME[]" id="PAGE_NAME" style="width:100.0%;">
                                    </div> 
                                    <div>
                                        <input type="submit" value="Delete" style="background-color: rgb(161, 1, 1); padding: 8px 50px; border-radius: 70px; border: transparent; color: white; font-family: system-ui; font-weight: bolder; cursor: pointer;">
                                    </div> 
                                </div>
                            </div>  
                        </form>
                        
                        <!-- Footer -->
                        <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                            <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                                <span style="color: white; font-weight: 600; ">
                                    © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                                </span>
                            </p>
                        </div>
                    </div>   
                </div>
            </div>
        </div>
    </body>
</html>