<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">STUDENT ATTENDANCE CERTIFICATE</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2" style="padding: 60px">
                        <form name="myform" method="POST" action="">
                            <input type="hidden" id="pagename" name="pagename" value="StudentAttendance">                       
                            <div style="display: flex; gap: 1%">
                                <div>
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px;">
                                        <span style="color:Red; font-size:medium;">*</span>&nbsp;Programme Name
                                    </label>
                                    <select onclick="selOpt()" class="custom-select" id="programme" name="programme" onchange="return jsFunction(this);">
                                        <option value="0" selected="selected">Select</option>
                                        <option value="3">Certificate </option>
                                        <option value="1">PGD </option>
                                        <option value="2">UGD </option>
                                    </select> 
                                    
                                    <!-- JavaScript inside or below form -->
                                    <script>
                                        document.getElementById('programme').addEventListener('change', function () {
                                            if (this.value === '1') {
                                                window.location.href = 'StudentAttendance.php';
                                            }
                                        });
                                        document.getElementById('programme').addEventListener('change', function () {
                                            if (this.value === '2') {
                                                window.location.href = 'StudentAttendanceUGD.php';
                                            }
                                        });
                                    </script>
                                </div>
                                <div id="div3">
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px"><span style="color:Red; font-size:medium;">*</span>&nbsp;Title</label>
                                    <select class="custom-select" id="crtnamecrt" name="crtnamecrt" onkeypress="clearBox();" required="">
                                        <option value="0" selected="selected">Select</option>
                                        <option value="60773">Blockchain for Medical Professionals&nbsp;-&nbsp;Batch-1 </option>           
                                        <option value="58914">Storage and Warehouse Techniques&nbsp;-&nbsp;Batch-1 </option>              
                                        <option value="58913">Certified Petroleum Professional (CPP)&nbsp;-&nbsp;Batch-1 </option>                    
                                        <option value="58295">Technical Training in Knitting Mechanics and Fabric Calculations&nbsp;-&nbsp;Batch-1 </option>                    
                                        <option value="58279">Certified Health and Physical Education Specialist&nbsp;-&nbsp;Batch-1 </option>                    
                                        <option value="57866">2-Week Certificate Course on Process Safety Management&nbsp;-&nbsp;Batch-1 </option>    
                                        <option value="56006">Data Analytics for Engineers&nbsp;-&nbsp;Batch-1 </option>               
                                        <option value="54768">Lean Six Sigma &amp; Lean Manufacturing&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="54541">Introduction to Electric Vehicles EVs&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="53638">Mastering Investment Strategies To Build Generational Wealth&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="52555">2-Week Certificate Course on Steady State Process Simulation for Typical Process Equipment&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="52532">Certified Safety Officer&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="52206">Project Risk Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="51973">12-Week Professional Certification Course on Certified Cyber Security Professional&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="51892">Certified Risk Manager CRM Training&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="51891">Functional Reverse Engineering&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="51890">Introduction to Financial Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="51887">Certificate in Engineering, Construction and Industrial Risk Insurance&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="51869">Digital Twinning-Discrete Manufacturing&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="51853">Shopify and Meta Ads&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="51483">3-Month Certificate Course on Aviation Engineering Management&nbsp;-&nbsp;Batch-1 </option>           
                                        <option value="51480">Raspberry PI and Python Programming&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="50851">Implement Energy Management System ISO 50001:2018 and Reduce Energy Cost&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="50848">Strategic Marketing in Banking&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="50839">Interpreter Development for CNC Controller - G&amp;M Codes to Digital Signals&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="50836">GIZ Professional Course on Sustainable Productivity Practices for Professionals (A Complete Toolkit)&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="50259">2-Month PGC course on Islamic Banking &amp; Finance&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="50226">Productivity Improvement by Better Time Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="49947">Turtle Soup (TS) and Candle Range Theory (CRT)&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="49790">Guided Project: Developing Blockchain Based e-kyc (know your customer) Application Project&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="49742">Sustainable Financing&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="49785">Arduino Masterclass&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="49741">Fire Loss Control - Roof Mounted Photovoltaic Systems&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="57817">4-Week ICT trading algorithm masterclass (crypto, forex and stocks)&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="48678">4-Week ICT trading algorithm masterclass (crypto, forex and stocks)&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="46825">Interior Design Workshop For Beginners&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="45408">English Language Extensive Speaking and Writing Proficiency Course-Level 2&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="45407">English Language Extensive Speaking Course-Level 1&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="43933">Sustainability &amp; Sustainable Product Development &amp; Profitable Future: Driving Growth with Life Cycle Assessment (LCA)&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="43882">Certified Project Management Professional (WITH PMP/CAPM EXAM PREPARATION)&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="43741">Digital Technology in Supply Chain&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="43715">Introduction to Pressure Vessels based on ASME VIII Div. 1 and API - 510&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="43739">4-Week Certified Procurement Management Professional&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="42367">2-Month Certificate course on Computational Fluid Dynamics - Online&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="54540">10-Week Certificate Course on Inventory Management&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="42360">10-Week Certificate Course on Inventory Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="56586">Cyber Security for Web 3.0 and Blockchain&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="42109">Cyber Security for Web 3.0 and Blockchain&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="42197">Chinese Language Course&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="39530">Vibration Monitoring &amp; Analysis&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="25896">Dummy GI&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="25383">3-Day Certificate Course on Industrial Energy Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="25323">Retail Operations and Customer Experience&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="53637">Supply Chain Management 360&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="25215">Supply Chain Management 360&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="25209">Constructing Safety Best Practices for a Safe Worksite&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="23430">Business Analytics Specialization&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="49750">3-Month Certificate Course on Digital Marketing&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="21279">Applied Lean Manufacturing With Cost Efficiency&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="21035">Financial Skills For Non-Finance Leaders &amp; Executives&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="21034">GIZ Professional Course on Dialogue for Sustainability&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="21028">GIZ Professional Course on Sustainable Productivity Practices through DfS&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="20450">Corporate Sustainability Integrating Governance Monitoring And Reporting&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="20124">Six-Sigma (Green Belt)&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="18905">4-Week Course on Welding Techniques And Inspections&nbsp;-&nbsp;Batch-1 </option>                
                                        <option value="18584">Customer Relationship Management (CRM)&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="18583">ODOO Supply-Chain Management System For Trading Industry&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="18385">Advanced Techniques In Renewables Energy And Storage&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="18384">Steady State And Dynamic Process Simulation&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="18383">Entrepreneurial Vermicomposting From Waste To Wealth&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="17761">Explore &amp; Learn Profitable Management&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="17625">ICT Trading Algorithm Masterclass (Crypto, Forex And Stocks)&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="17221">Introduction To Artificial Intelligence For Engineers&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="17040">Public Administration Professional&nbsp;-&nbsp;Batch-1 </option>                      
                                        <option value="14584">Self-Effectiveness &amp; Professional Development&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="13632">Water Treatment For Cooling Towers And Boiler Feed&nbsp;-&nbsp;Batch-1 </option>                      
                                        <option value="13435">Condition Monitoring &amp; Maintenance Strategies&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="13431">Industrial Energy Management&nbsp;-&nbsp;Batch-1 </option>                      
                                        <option value="13285">Entrepreneurship The Game Changer&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="13235">Technical Analysis For Trading Financial Markets&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="13172">E-Commerce&nbsp;-&nbsp;Batch-1 </option>                      
                                        <option value="13042">Solidworks For Engineers &amp; Freelancers&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="12638">3-Month Certificate Course On Inventory Management&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="12637">Python Programming Advance&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="12576">Certified Supply Chain Professional (CSCP)&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="60444">Certified Supply Chain Professional (CSCP)&nbsp;-&nbsp;Batch-2 </option>                     
                                        <option value="12347">Waste Heat Recovery Management And Capex&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="12303">SQL For Relational Database Management System (RDBMS)&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="12302">Design &amp; Development Concepts In Air Conditioning With Modern Practices&nbsp;-&nbsp;Batch-1 </option>                
                                        <option value="58286">Design &amp; Development Concepts In Air Conditioning With Modern Practices&nbsp;-&nbsp;Batch-2 </option>               
                                        <option value="10817">Green Financing&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="25315">Data Analyst In Microsoft Excel And SQL&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="10566">Data Analyst In Microsoft Excel And SQL&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="9507">Cloud Computing Data Security&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="20120">Procurement Management &nbsp;-&nbsp;Batch-2 </option>
                                        <option value="8210">Lifting Equipment Inspection&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="7194">Labs Based Approach To Docker Containers And Kubernetes Containers Orchestration&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="6866">Statistical Quality Control For Professionals&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="6635">SAP-MM Material Managament&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="6382">PHP Server Scripting Language&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="6064">Communication Master Class&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="5615">DevOps Engineering&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="5567">Maintenance Management, Operational Excellence, Technical Project &amp; Safety Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="5525">Pytorch For Data Scientists&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="18330">Pytorch For Data Scientists&nbsp;-&nbsp;Batch-0 </option>
                                        <option value="16842">Pytorch For Data Scientists&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="5524">Oracle Business Intelligence Enterprise Edition (OBIEE 12c)&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="13661">NLP Practitioner&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="5014">Pressure Die-Casting Production&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="4794">Strategic Management For Professional Managers And Senior Engineers&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="4793">Mastering Amazon Wholesale FBA (USA) With Practical Approach&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="4757">Computer Security&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="4516">Non Destructive Techniques And International Practice In Industries&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="4239">Introduction To Asset Valuation&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="4169">Governance, Risk And Compliance (GRC) In Cyber Security&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="4168">UI UX And Design Thinking&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="3965">Certified Professional Trainer/Master Trainer&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="3961">SAP ABAP&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="3960">Maintenance And Reliability In Plant Operations&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="3959">Organizational Performance Improvement&nbsp;-&nbsp;Batch-1 </option>                
                                        <option value="3958">GRE Preparation&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="45414">GRE Preparation&nbsp;-&nbsp;Batch-3 </option>
                                        <option value="18353">GRE Preparation&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="3956">Motion Graphics Editing And 2D Animation&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="3954">Mind Sciences And Mind Engineering Professional&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="3952">Certified Organizational Development Practitioner&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="58282">Automotive Technician&nbsp;-&nbsp;Batch-3 </option>               
                                        <option value="18335">Automotive Technician&nbsp;-&nbsp;Batch-2 </option>                        
                                        <option value="3951">Automotive Technician&nbsp;-&nbsp;Batch-1 </option>       
                                        <option value="48676">Data Analyst In Microsoft Power BI&nbsp;-&nbsp;Batch-3 </option>                       
                                        <option value="3437">Data Analyst In Microsoft Power BI&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="12574">Data Analyst In Microsoft Power BI&nbsp;-&nbsp;Batch-2 </option>               
                                        <option value="3418">Project Management Using MS Project&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="58280">Project Management Using MS Project&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="3417">Boiler Safety And Energy Audit To Conserve Energy&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="5616">Boiler Safety And Energy Audit To Conserve Energy&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="18332">Logistics, Transportation And Distribution Management&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="3264">Logistics, Transportation And Distribution Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="3263">Steady State Process Simulation For Typical Process Equipment&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="50110">Steady State Process Simulation For Typical Process Equipment&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="3262">Sustainable Corporate Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="3261">Understanding, Predicting, Preventing, Precautions And Remedies For Membrane Scaling &amp; Membrane Foul&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="4410">Understanding, Predicting, Preventing, Precautions And Remedies For Membrane Scaling &amp; Membrane Foul&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="2745">Oracle Database Administration For Beginners&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="2590">Halal Management System&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="2534">Mastering The Entrepreneurial Process&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="4404">Mastering The Entrepreneurial Process&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="2349">Machine Learning&nbsp;-&nbsp;Batch-1 </option>        
                                        <option value="2348">Welding Techniques And Inspections&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="7226">English Language Extensive Speaking Course&nbsp;-&nbsp;Batch-3 </option>                       
                                        <option value="3957">English Language Extensive Speaking Course&nbsp;-&nbsp;Batch-2 </option>                        
                                        <option value="18334">English Language Extensive Speaking Course&nbsp;-&nbsp;Batch-4 </option>                        
                                        <option value="1919">English Language Extensive Speaking Course&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="1688">Strategic Management&nbsp;-&nbsp;Batch-1 </option>                      
                                        <option value="1687">Lean Fundamentals For Service And Manufacturing Organizations&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="1333">Certification In Islamic Banking And Finance&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="5568">Security Operations Centre (SOC) Analyst&nbsp;-&nbsp;Batch-2 </option>
                                        <option value="760">Security Operations Centre (SOC) Analyst&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="759">Understanding Of Sheet Metal Parts Production&nbsp;-&nbsp;Batch-1 </option>               
                                        <option value="20533">Understanding Of Sheet Metal Parts Production&nbsp;-&nbsp;Batch-2 </option>                       
                                        <option value="466">Exploring Enterprise Resource Planning&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="140">World Class Manufacturing Management&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="81">SketchUp And VRay Basic Workshop For Interior Design&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="23415">Certified Fire Protection Facilitator&nbsp;-&nbsp;Batch-4 </option>                       
                                        <option value="52592">Certified Fire Protection Facilitator&nbsp;-&nbsp;Batch-5 </option>                       
                                        <option value="79">Certified Fire Protection Facilitator&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="1954">Certified Fire Protection Facilitator&nbsp;-&nbsp;Batch-2 </option>                        
                                        <option value="8205">Certified Fire Protection Facilitator&nbsp;-&nbsp;Batch-3 </option>                       
                                        <option value="56">Plant Operation, Maintenance And Safety&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="55">Sustainable Waste Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="52">Apparel And Merchandising Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="51">Computer Aided Pattern Design And Product Development&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="48">Supply Chain Design And Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="47">Performance Appraisal And Compensation Management&nbsp;-&nbsp;Batch-1 </option>        
                                        <option value="46">Lean Six Sigma&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="45">Principles Of Marketing&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="44">Project Management Tools (PRIMAVERA And AGILE)&nbsp;-&nbsp;Batch-1 </option>               
                                        <option value="43">International And Best Value Procurement&nbsp;-&nbsp;Batch-1 </option>                    
                                        <option value="42">Construction Informatics And Cost Estimation&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="41">Inventory Management&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="40">Project Management Framework And Tools&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="28">Professional Certification In Aviation Management&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="27">Performance Management And Managerial Accounting Practices In Aviation&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="22">Cyber Security Offensive&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="21">Information Risk Management&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="17">2-Month PGC course on Python Programming&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="16">Front End Designing&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="13">Hazard Recognition &amp; Risk Mitigation Strategies&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="12">Language Testing And Assessment&nbsp;-&nbsp;Batch-1 </option>
                                        <option value="11">Engineering Insurance&nbsp;-&nbsp;Batch-1 </option>        
                                        <option value="9">Hypnosis&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="8">Safety and Quality in the Food Processing&nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="7">Industrial Psychology and Organizational Behaviour&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="18355">IELTS Preparation &nbsp;-&nbsp;Batch-4 </option>                        
                                        <option value="45411">IELTS Preparation &nbsp;-&nbsp;Batch-5 </option>                       
                                        <option value="3966">IELTS Preparation &nbsp;-&nbsp;Batch-3 </option>                       
                                        <option value="93">IELTS Preparation &nbsp;-&nbsp;Batch-1 </option>                        
                                        <option value="1681">IELTS Preparation &nbsp;-&nbsp;Batch-2 </option>                       
                                        <option value="68">Mechanical Engineering Practices and Concepts In Industry&nbsp;-&nbsp;Batch-1 </option>              
                                        <option value="52040">Mechanical Engineering Practices and Concepts In Industry&nbsp;-&nbsp;Batch-2 </option>                       
                                        <option value="53">HR Generalist&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="1952">Ethical Hacking&nbsp;-&nbsp;Batch-2 </option>                       
                                        <option value="50">Ethical Hacking&nbsp;-&nbsp;Batch-1 </option>                       
                                        <option value="1953">3-Month Certificate Course on Python Programming&nbsp;-&nbsp;Batch-2 </option>      
                                        <option value="49">3-Month Certificate Course on Python Programming&nbsp;-&nbsp;Batch-1 </option>
                                    </select>
                                </div>             
                                <div>      
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px"><span style="color:Red; font-size:medium;">*</span>&nbsp;Attendance Date</label>                             
                                    <input type="date" name="tdate" id="tdate" 
                                    style="display:block; width:100%; padding:.375rem .75rem;font-size:1rem;font-weight:400;line-height:1.5;color:#495057;background-color:#fff;
                                    background-clip:padding-box; border:1px solid #ced4da;border-radius:.25rem;">                                  
                                </div>       
                            </div> 
                            <div style="display: flex; justify-content: center; padding-top: 40px;">
                                <input type="submit" value="SUBMIT"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;
                                    font-weight: bolder;cursor: pointer;" />
                            </div>
                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>