<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">STUDENT ATTENDANCE UGD</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2" style="padding: 60px">
                        <form name="myform" method="POST" action="">
                            <input type="hidden" id="pagename" name="pagename" value="StudentAttendance">                       
                            <div style="display: flex; gap: 1%">
                                <div>
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px">
                                        <span style="color:Red; font-size:medium;">*</span>&nbsp;Programme Name
                                    </label>
                                    <select onclick="selOpt()" class="custom-select" id="programme" name="programme" onchange="return jsFunction(this);">
                                        <option value="0" selected="selected">Select</option>
                                        <option value="3">Certificate </option>
                                        <option value="1">PGD </option>
                                        <option value="2">UGD </option>
                                    </select>    

                                    <!-- JavaScript inside or below form -->
                                    <script>
                                        document.getElementById('programme').addEventListener('change', function () {
                                            if (this.value === '1') {
                                                window.location.href = 'StudentAttendance.php';
                                            }
                                        });
                                        document.getElementById('programme').addEventListener('change', function () {
                                            if (this.value === '3') {
                                                window.location.href = 'StudentAttendanceCertificate.php';
                                            }
                                        });
                                    </script>
                                </div>
                                <div id="div2">
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px">
                                        <span style="color:Red; font-size:medium;">*</span>&nbsp;UGD Course
                                    </label>
                                    <select class="custom-select" id="crtname" name="crtname">
                                        <option value="0" selected="selected">Select</option>
                                        <option value="All">All</option>            
                                        <option value="21">Advance Web Programming Via PHP </option>
                                        <option value="34">Basics of AI and its Applications  </option>
                                        <option value="41">Business Intelligence  </option>
                                        <option value="39">Calculus and Linear Algebra </option>
                                        <option value="35">Calculus and Linear Algebra </option>
                                        <option value="12">Computer Networks </option>
                                        <option value="16">Computer Programming (PYTHON) </option>
                                        <option value="40">Data Analysis and Visualization </option>
                                        <option value="13">Database Management System (DBMS) </option>
                                        <option value="19">Database Management Systems </option>
                                        <option value="27">Design Tools &amp; Softwares </option>
                                        <option value="8">Digital Marketing </option>
                                        <option value="23">Fabric Preparatory Processes </option>            
                                        <option value="2">Game Modelling by Unity 2D &amp; 3D, Illustrator </option>            
                                        <option value="26">Garment Manufacturing  </option>            
                                        <option value="5">Graphic Design Advance </option>            
                                        <option value="29">Graphic Design Advance  </option>            
                                        <option value="4">Graphic Design Base </option>            
                                        <option value="28">Graphic Design Base </option>            
                                        <option value="15">Graphics Designing  </option>            
                                        <option value="10">Introduction to Basics &amp; Office Automation  </option>            
                                        <option value="1">Introduction to Gaming Industry, Game Programming &amp; Game Designing  </option>            
                                        <option value="3">Introduction to Physics in Game Development </option>            
                                        <option value="22">Introduction to Textiles </option>            
                                        <option value="36">Machine Learning and its Applications </option>            
                                        <option value="31">Modeling and Animation  </option>            
                                        <option value="18">Object Oriented Programming (PYTHON) </option>            
                                        <option value="14">Operating System  </option>            
                                        <option value="9">Photography </option>
                                        <option value="32">Post-Production  </option>            
                                        <option value="24">Pre-Treatment &amp; Dyeing  </option>            
                                        <option value="20">Programming with Data Structures </option>            
                                        <option value="33">Python for AI </option>            
                                        <option value="38">Python for Data Science </option>            
                                        <option value="37">SQL and databases </option>            
                                        <option value="42">SQL and databases </option>            
                                        <option value="17">Software Engineering Principals </option>            
                                        <option value="25">Textile Printing &amp; Finishing  </option>            
                                        <option value="30">UI/UX Design </option>            
                                        <option value="6">Video Editing and Animations </option>            
                                        <option value="7">Web Design and Development </option>            
                                        <option value="11">Web Designing and Development </option>           
                                    </select>  
                                </div>
                                   
                                <div id="sem">
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px"><span style="color:Red; font-size:medium;">*</span>&nbsp;Semester</label>    
                                    <select class="custom-select" id="semester" name="semester" onkeypress="clearBox();" required="">
                                        <option value="0" selected="selected">Select</option>           
                                        <option value="8">Fall-I-2025 </option>
                                        <option value="7">Spring-I-2025 </option>
                                        <option value="6">Fall-II-2024 </option>
                                        <option value="5">Fall-I-2024 </option>
                                        <option value="4">Spring-II-2024 </option>
                                        <option value="3">Spring-I-2024 </option>
                                        <option value="2">Fall-I-2023 </option>
                                        <option value="1">Old Semesters </option>
                                    </select>           
                                </div>             
                                <div>      
                                    <label for="exampleInputEmail1" class="text" style="padding-bottom: 10px"><span style="color:Red; font-size:medium;">*</span>&nbsp;Attendance Date</label>                             
                                    <input type="date" name="tdate" id="tdate"
                                    style="display:block; width:100%; padding:.375rem .75rem;font-size:1rem;font-weight:400;line-height:1.5;color:#495057;background-color:#fff;
                                    background-clip:padding-box; border:1px solid #ced4da;border-radius:.25rem;">                                  
                                </div>       
                            </div> 
                            <div style="display: flex; justify-content: center; padding-top: 40px;">
                                <input type="submit" value="SUBMIT"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;
                                    font-weight: bolder;cursor: pointer;" />
                            </div>
                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>