<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">TEACHER COURSE ASSIGN FOR PGD</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                        LOGOUT
                                    </a>
                                </button>   
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>

                        <div class="container2">
                            <div >         
                                <div class="form-group">
                                    <form name="myform" method="POST" action="addteacherassign" target="_blank">
                                        <div style="display: flex; gap: 1%; text-align: center;">
                                            <div >
                                                <label class="text" style="text-align: centre"><span style="color:Red; font-size:medium;">*</span>&nbsp;Teacher</label>
                                                <select id="teacher" name="teacher" onkeypress="clearBox();" class="custom-select" required="">
                                                    <option value="0" selected="selected">Select</option>
                                                    <option value="4">Farrukh Arif </option>
                                                    <option value="11">Maqsood Ahmed Khan </option>
                                                    <option value="13">Fariha Asim </option>
                                                    <option value="14">Muhammad Owais Raza Siddiqui </option>
                                                    <option value="54">Umbrin Sultana </option>
                                                    <option value="64">-Ing. Shehzad Hasan </option>        
                                                    <option value="38">Shariq Shaikh </option>        
                                                    <option value="39">Zahoor Ul Hussain Awan </option>        
                                                    <option value="71">Rashid Ahmed Khan </option>        
                                                    <option value="72">Haider Ali </option>        
                                                    <option value="75">Murk Marvi </option>        
                                                    <option value="76">Maria Andleeb Siddiqui </option>        
                                                    <option value="79">Muhammad Mohsin Aman </option>       
                                                    <option value="84">Rizwan Aslam Butt </option>        
                                                    <option value="86">Arshad Siddiqui </option>       
                                                    <option value="95">Muhammad Amir Qureshi </option>       
                                                    <option value="111">Arsalan Waheed </option>        
                                                    <option value="6">Muhammad Fareed </option>        
                                                    <option value="7">Bilal Zahid </option>        
                                                    <option value="8">Faraz Akbar </option>        
                                                    <option value="9">Kashif Asrar </option>       
                                                    <option value="10">Umar Iftikhar </option>        
                                                    <option value="12">Muhammad Ali </option>        
                                                    <option value="46">Jawaad Ahmed Ansari </option>        
                                                    <option value="24">Noman Uddin Yousuf </option>        
                                                    <option value="36">Muhammad Ali Ismail </option>        
                                                    <option value="56">Syed Imran Ahmed </option>        
                                                    <option value="22">Sehrish Naveed </option>       
                                                    <option value="58">Muhammad Aslam Bhutto </option>        
                                                    <option value="65">Maria Waqas </option>        
                                                    <option value="66">Abdul Karim Kazi </option>        
                                                    <option value="69">Syed Tauqeer Ahmed Hashmi </option>        
                                                    <option value="70">Muhammad Masood Rafi </option>        
                                                    <option value="78">Syed Amir Iqbal </option>        
                                                    <option value="85">Atif Mustafa </option>       
                                                    <option value="88">Mirza Hammad Baig </option>       
                                                    <option value="90">Ahsan Ahmed </option>        
                                                    <option value="97">Syed Siraj Uddin </option>        
                                                    <option value="108">Saima Gul </option>        
                                                    <option value="32">Ghazanfar Hussain </option>        
                                                    <option value="37">Najeed Ahmed Khan </option>        
                                                    <option value="40">Nida Azhar </option>        
                                                    <option value="44">Danish Ur Rehman Khan </option>        
                                                    <option value="45">Rana Rabnawaz Ahmed </option>        
                                                    <option value="48">Zakir Hussain Khan </option>        
                                                    <option value="49">Sohail Ahmed </option>        
                                                    <option value="51">Syed Riaz Un Nabi Jafri </option>        
                                                    <option value="52">Muhammad Faizan Shirazi </option>        
                                                    <option value="53">Adnan Qadir </option>       
                                                    <option value="57">Junaid Kareem Khan </option>        
                                                    <option value="67">Rohail Qamar </option>        
                                                    <option value="68">Muhammad Imran </option>        
                                                    <option value="81">Ghous Bakhsh </option>        
                                                    <option value="91">Mubashir Ali Siddiqui </option>        
                                                    <option value="93">Imran Nabi </option>       
                                                    <option value="109">Assad Anis </option>        
                                                    <option value="110">Shahnaz Tabassum </option>        
                                                    <option value="3">Farnaz Batool </option>        
                                                    <option value="33">Muhammad Rashid Malik </option>        
                                                    <option value="34">Muhammad Naveed Ajmal </option>        
                                                    <option value="41">Muhammad Naveel </option>       
                                                    <option value="43">Kashif Mehboob Khan </option>       
                                                    <option value="47">Abdul Ghaffar </option>        
                                                    <option value="59">Syed Zaffar Qasim Naqvi </option>        
                                                    <option value="60">Muhammad Kamran </option>        
                                                    <option value="61">Syed Abbas Ali </option>                       
                                                    <option value="77">Waseemullah </option>        
                                                    <option value="80">Waleed Ahmed Khan </option>       
                                                    <option value="83">Yasir Hussain Khan </option>        
                                                    <option value="92">Aqeel Ahmed Khan </option>       
                                                    <option value="94">Muhammad Dawood Husain </option>        
                                                    <option value="96">Faaz Ahmed Butt </option>        
                                                    <option value="50">Fareed Ahmad </option>        
                                                    <option value="5">Almas Ashraf </option>        
                                                    <option value="35">Saud Hashmi </option>        
                                                    <option value="42">Muhammad Jawwad Khan </option>        
                                                    <option value="55">Haider Hasan </option>        
                                                    <option value="62">Samia Masood Awan </option>        
                                                    <option value="63">Shariq Mahmood Khan </option>        
                                                    <option value="73">Muhammad Mubashir Khan </option>       
                                                    <option value="74">Usman Amjad </option>        
                                                    <option value="82">Mirza Mahmood Baig </option>        
                                                    <option value="87">Muhammad Uzair </option>        
                                                    <option value="89">Talha Bin Nadeem </option>        
                                                    <option value="102">Muhammad Nabeel Ibrahim Khan </option>      
                                                </select>
                                            </div>
                                            <div >
                                                <label for="exampleInputEmail1" class="text"><span style="color:Red; font-size:medium;">*</span>&nbsp;Programme Name</label>
                                                <select onclick="selOpt()" class="custom-select " id="programme" name="programme" onchange="return jsFunction(this);">
                                                    <option value="0" >Select</option>
                                                    <option value="1">PGD </option>
                                                    <option value="2">UGD </option>
                                                    <option value="3">Certificate </option>
                                                </select>

                                                <!-- JavaScript inside or below form -->
                                                <script>
                                                    document.getElementById('programme').addEventListener('change', function () {
                                                        if (this.value === '3') {
                                                            window.location.href = 'TeacherCourseAssignCertificate.php';
                                                        }
                                                    });
                                                </script>

                                                <script>
                                                    document.getElementById('programme').addEventListener('change', function () {
                                                        if (this.value === '2') {
                                                            window.location.href = 'TeacherCourseAssignUGD.php';
                                                        }
                                                    });
                                                </script>
                                            </div>
                                            <div >
                                                <label for="exampleInputEmail1" class="text"><span style="color:Red; font-size:medium;">*</span>&nbsp;PGD Course</label>
                                                <select class="custom-select" id="crtname1" name="crtname1">
                                                    <option value="0" >Select</option>
                                                    <option value="All">All</option>
                                                    <option value="58">Accounting and Financial Management </option>
                                                    <option value="76">Advanced Analysis of Algorithms </option>
                                                    <option value="65">Advanced Blockchain Technology for Enterprises </option>
                                                    <option value="20">Advanced Garment Production Processes </option>
                                                    <option value="147">Advanced Project Management Processes </option>
                                                    <option value="51">Advanced Unit Operations </option>
                                                    <option value="86">Agile and Lean Manufacturing </option>
                                                    <option value="26">Apparel and Merchandising Management </option>
                                                    <option value="8">Approaches and Methods in English language Teaching </option>
                                                    <option value="81">Artificial Neural Networks </option>
                                                    <option value="112">Auditing &amp; Assurance </option>
                                                    <option value="54">Brand Management &amp; Social Media Marketing </option>
                                                    <option value="136">Business &amp; Taxation Laws </option>
                                                    <option value="150">Business Communication </option>
                                                    <option value="87">Business Intelligence </option>
                                                    <option value="139">Claims &amp; Disputes </option>
                                                    <option value="4">Cloud Application Security </option>
                                                    <option value="1">Cloud Computing Concepts and Design </option>
                                                    <option value="2">Cloud Computing Data Security </option>
                                                    <option value="5">Cloud Computing Operations  </option>
                                                    <option value="3">Cloud Platform and Infrastructure Security </option>
                                                    <option value="117">Commercial Property and Business Interruption Insurance </option>
                                                    <option value="7">Communication Skills for English Language Teachers </option>
                                                    <option value="99">Computer Aided Construction Project Management Using Primavera &amp; Building Information Modeling </option>
                                                    <option value="19">Computer Aided Pattern Design and Product Development </option>
                                                    <option value="98">Construction Finance, Quality and Safety Management  </option>
                                                    <option value="96">Construction Informatics and Cost Estimatation </option>
                                                    <option value="94">Construction Materials, Technology and Processes </option>
                                                    <option value="97">Construction Project Management Framework &amp; Implementation  </option>
                                                    <option value="138">Contract Management </option>
                                                    <option value="154">Corporate Governance </option>
                                                    <option value="64">Cryptography for Blockchain </option>
                                                    <option value="92">Cyber Security (Core) </option>
                                                    <option value="95">Cyber Security (Defensive) </option>
                                                    <option value="90">Cyber Security (Foundation) </option>
                                                    <option value="93">Cyber Security (Offensive)  </option>
                                                    <option value="67">DApps Development using Web 3.0 </option>
                                                    <option value="89">Data Visualization </option>
                                                    <option value="71">Database Designing and Development </option>
                                                    <option value="83">Deep Learning </option>
                                                    <option value="12">Denim Manufacturing Processes </option>
                                                    <option value="13">Denim Product Development &amp; Design </option>
                                                    <option value="46">Desalination Techniques </option>
                                                    <option value="41">Desalination and Reverse Osmosis Technology </option>
                                                    <option value="78">Digital Forensics </option>
                                                    <option value="102">Economic Development </option>
                                                    <option value="104">Economic Policies of Governments </option>
                                                    <option value="62">Emerging Technologies for Food Processing </option>
                                                    <option value="106">Employment Laws </option>
                                                    <option value="37">Energy Audits </option>
                                                    <option value="84">Energy Management </option>
                                                    <option value="38">Energy Planning </option>
                                                    <option value="118">Engineering Insurance  </option>
                                                    <option value="124">Ensuring World Class Safety Management </option>
                                                    <option value="79">Ethical Hacking </option>
                                                    <option value="110">Financial Accounting  </option>
                                                    <option value="113">Financial Management </option>
                                                    <option value="111">Financial Reporting </option>
                                                    <option value="72">Front End Designing </option>
                                                    <option value="69">Functional Foods </option>
                                                    <option value="28">Fundamentals of Polymer Science &amp; Technology </option>
                                                    <option value="75">Fundamentals of Sustainable Engineering </option>
                                                    <option value="17">Garment Manufacturing Fundamentals </option>
                                                    <option value="15">Garment Quality Management </option>
                                                    <option value="109">HR Best Practices towards Sustaining Industrial Growth </option>
                                                    <option value="121">Hazard Recognition &amp; Risk Mitigation Strategies </option>
                                                    <option value="120">Health &amp; Safety Foundation </option>
                                                    <option value="108">Health and Safety Laws </option>
                                                    <option value="44">Human Resource Management </option>
                                                    <option value="157">Hypnosis </option>
                                                    <option value="129">ISO Quality Certification and Audit Management </option>
                                                    <option value="53">Industrial Marketing </option>
                                                    <option value="105">Industrial Relations </option>
                                                    <option value="91">Information Risk Management </option>
                                                    <option value="116">Insurance Business and Finance </option>
                                                    <option value="137">International &amp; Best Value Procurement </option>
                                                    <option value="160">Introduction to Industrial Physcology and Organizational Behaviour </option>
                                                    <option value="155">Introduction to Mind Science &amp; Mind Engineering </option>
                                                    <option value="130">Introduction to Production Management </option>
                                                    <option value="142">Inventory Management </option>
                                                    <option value="77">Knowledge Based Systems </option>
                                                    <option value="10">Language Testing and Assessment </option>
                                                    <option value="164">Leadership &amp; Motivation </option>
                                                    <option value="151">Leadership in Commercial Organizations </option>
                                                    <option value="126">Lean Six Sigma </option>
                                                    <option value="6">Legal and Compliance </option>
                                                    <option value="141">Logistics, Transportation and Distribution Management </option>
                                                    <option value="85">Machine Learning </option>
                                                    <option value="101">Macroeconomics </option>
                                                    <option value="103">Managerial Economics </option>
                                                    <option value="40">Membrane Filtration </option>
                                                    <option value="100">Microeconomics </option>
                                                    <option value="156">NLP </option>
                                                    <option value="163">NLP Techniques </option>
                                                    <option value="25">Orgainzational Systems </option>
                                                    <option value="165">Organizational Improvement and Sustaining Industrial Growth </option>
                                                    <option value="128">Organizational Management </option>                                              
                                                    <option value="33">Organizational Systems </option>
                                                    <option value="45">Performance Appraisal &amp; Compensation Management </option>
                                                    <option value="158">Performance Excellence  </option>
                                                    <option value="42">Plant, Operation, Maintenance &amp; Safety </option>
                                                    <option value="29">Polymer Morphology-Property Relationships </option>
                                                    <option value="31">Polymer Processing </option>
                                                    <option value="32">Polymer Rheology </option>
                                                    <option value="30">Polymeric Materials and Characterization </option>
                                                    <option value="48">Predictive HR Analytics </option>
                                                    <option value="49">Principles of Marketing </option>
                                                    <option value="115">Principles of Risk Management and Insurance   </option>
                                                    <option value="55">Process Safety Management </option>
                                                    <option value="135">Procurement Management </option>
                                                    <option value="144">Procurement and Contracts Management </option>
                                                    <option value="35">Project Evaluation and Feasibility Analysis </option>
                                                    <option value="149">Project Leadership and Governance </option>
                                                    <option value="145">Project Management Framework and Environment </option>
                                                    <option value="34">Project Management Framework and Tools </option>
                                                    <option value="146">Project Management Processes </option>
                                                    <option value="148">Project Management Tools (Primavera and Agile) </option>
                                                    <option value="70">Python Programming </option>
                                                    <option value="63">Python for Blockchain </option>
                                                    <option value="74">Python for Data Science </option>
                                                    <option value="119">Reinsurance Principles and Practices </option>
                                                    <option value="166">Reliability Engineering </option>
                                                    <option value="123">Safety &amp; Emergency Management  </option>
                                                    <option value="122">Safety Leadership, Culture &amp; Communication  </option>
                                                    <option value="57">Safety and Quality in the Food Processing </option>
                                                    <option value="21">Sewn Product Engineering </option>
                                                    <option value="66">Smart Contracts¿Development &amp; Deployment for Blockchain Backend </option>
                                                    <option value="68">Software Development (Foundation) </option>
                                                    <option value="47">Strategic Human Resource Management   </option>
                                                    <option value="60">Strategic Planning and Decision Making </option>
                                                    <option value="159">Super Mind Programing  </option>
                                                    <option value="24">Supply Chain Design and Management </option>
                                                    <option value="140">Supply Chain Management </option>
                                                    <option value="80">Sustainability - Economics, Tools, Management </option>
                                                    <option value="82">Sustainable Waste Management </option>
                                                    <option value="11">Syllabus Design and Curriculum Development in ELT </option>
                                                    <option value="27">Textile Brand Management and Marketing </option>
                                                    <option value="88">Tools and Techniques for Data Science </option>
                                                    <option value="23">Total Quality Management </option>
                                                    <option value="39">Water Treatment Techniques </option>
                                                    <option value="73">Web Development Via PhP </option>
                                                    <option value="107">Welfare Laws </option>
                                                    <option value="9">World Englishes and Technology in Language </option>
                                                </select>
                                            </div>
                                    
                                            <div>
                                                <label for="exampleInputEmail1" class="text"><span style="color:Red; font-size:medium;">*</span>&nbsp;Semester</label>
                                                <select class="custom-select" id="semesterugd" name="semesterugd" onkeypress="clearBox();" required="">
                                                    <option value="0" >Select</option>
                                                    <option value="9">Summer-2025 </option>
                                                    <option value="8">Spring-I-2025 </option>
                                                    <option value="7">Fall-II-2024 </option>
                                                    <option value="6">Fall-I-2024 </option>
                                                    <option value="5">Summer-2024 </option>
                                                    <option value="4">Spring-II-2024 </option>
                                                    <option value="3">Spring-I-2024 </option>
                                                    <option value="2">Fall-I-2023 </option>
                                                    <option value="1">Old Semesters </option>
                                                </select>                                       
                                            </div>                                 
                                        </div>
                                        <div style="display: flex; justify-content: center; padding-top: 40px;">
                                            <input type="submit" value="SUBMIT"
                                                style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                                        </div>
                                    </form>
                                </div>  
                                <div>  
                                    <form name="myform" method="POST" action="addteacherassign" >
                                        <div >        
                                            <div >
                                                <label class="text">Teacher</label>         
                                            </div>
                                            <div >
                                                <label class="text">Programme</label>
                                            </div>
                                            <div >
                                                <label class="text">Course Name</label>
                                            </div>
                                            <div >
                                                <label class="text">Semester</label>
                                            </div>
                                        </div>
                                        <div >
                                            <div >
                                                <label style="color:Black;">Farrukh Arif</label>
                                            </div>
                                            <div >
                                                <label style="color:Black;">PGD</label>
                                            </div>
                                            <div >
                                                <label style="color:Black;">Accounting and Financial Management</label>
                                            </div>
                                            <div >
                                                <label style="color:Black;">Fall-II-2024</label>
                                            </div>           
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Footer -->
                        <div class="container3" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                            <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                                <span style="color: white; font-weight: 600; ">
                                    © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>