<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();

    
    // Handle GET request: clear session unless it's immediately after a POST
    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        if (!isset($_SESSION['just_posted'])) {
            unset($_SESSION['course_data']);
            unset($_SESSION['dates_data']);
        } else {
            unset($_SESSION['just_posted']); // clear flag
        }
    }

    // Handle form submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['add_course'])) {
            $_SESSION['course_data'] = [
                'course_name' => $_POST['course_name'],
                'abbreviation' => $_POST['abbreviation']
            ];
        }

        if (isset($_POST['add_dates'])) {
            $_SESSION['dates_data'] = $_POST;
        }

        $_SESSION['just_posted'] = true;

        // Redirect to avoid resubmission
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 116%; position: relative; left: -90px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                            <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">ADD UGD COURSE</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                            <button class="logout-btn" style="background: none; border: none;">
                                <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                LOGOUT
                                </a>
                            </button>
                            </div>
                            <div style="padding-left: 30px;">
                            <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                BACK
                            </button>
                            </div>
                        </div>
                    </div>

                    <div class="container2">
                        <form method="POST">
                            <div class="form-row">
                                <div style="width: 100%;">
                                    <label class="text">Course Name</label><br>
                                    <input class="custom-select-cc" name="course_name" type="text" placeholder="UGD Course Title" required
                                        value="<?= isset($_SESSION['course_data']) ? $_SESSION['course_data']['course_name'] : '' ?>">
                                </div>
                                <div>
                                    <label class="text">Abbreviation</label><br>
                                    <input class="custom-select-abb" name="abbreviation" type="text" placeholder="UGD Abbreviation" required
                                        value="<?= isset($_SESSION['course_data']) ? $_SESSION['course_data']['abbreviation'] : '' ?>">
                                </div>
                            </div>
                            <div style="text-align: center;">
                                <input type="submit" name="add_course" value="ADD ROW" class="add-row-btn">
                            </div>
                        </form>

                        <!-- Example Table: Replace with dynamic rendering if needed -->
                        <div style="padding-bottom: 40px; padding-left: 110px; padding-right: 58px; padding-top: 20px;">
                            <?php if (isset($_SESSION['course_data'])): ?>
                                <table>
                                    <thead>
                                        <tr style="background-color: #a10101; color: white;">
                                            <th>#</th>
                                            <th>Course Name</th>
                                            <th>Abbreviation</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr style="text-align: center;">
                                            <td>1</td>
                                            <td contenteditable="true"><?= $_SESSION['course_data']['course_name'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['course_data']['abbreviation'] ?></td>
                                            <td style="background: none; border: none; width: 20%;"><button class="update-btn" style="padding: 10px 32px;">UPDATE</button></td>
                                        </tr>
                                    </tbody>
                                </table>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="container3">
                        <div style="background-color: white;">
                            <h2 class="text-center" style="color: rgba(28, 28, 78, 0.92); margin: 0; font-size: xx-large; padding-bottom: 30px; padding-top: 30px; font-weight: 700;">
                                ADD UGD DATES
                            </h2>
                        </div>
                    </div>

                    <div class="container4" style="background-color: #f5f7fa;">
                        <form id="datesForm" method="POST">
                            <div class="container-fluid">
                                <div style="padding-right: 20px;">
                                    <div style="display: flex; padding-top: 40px; margin-left: 80px; margin-right: 90px;">
                                        <div >
                                            <label class="text" style="width: 110%;">Mode Of Learning</label>
                                            <select style="width: 70%;" id="mode" name="mode" class="custom-select-duration" required="">
                                                <option value="0" selected="selected">Select</option>
                                                <option value="Hybrid Mode (Online + Physical)" <?= (isset($_SESSION['dates_data']['mode']) && $_SESSION['dates_data']['mode'] == 'Hybrid Mode (Online + Physical)') ? 'selected' : '' ?>>Hybrid Mode (Online + Physical)</option>
                                                <option value="Distance Learning Mode (Online)" <?= (isset($_SESSION['dates_data']['mode']) && $_SESSION['dates_data']['mode'] == 'Distance Learning Mode (Online)') ? 'selected' : '' ?>>Distance Learning Mode (Online)</option>
                                            </select>
                                        </div>
                                        <div style="position: relative; left: -50px; top: -1px;">
                                            <label class="text">Semester</label>
                                            <input type="text" name="semester" class="custom-select-duration" placeholder="Batchname-I-year" required value="<?= $_SESSION['dates_data']['semester'] ?? '' ?>">
                                        </div>        
                                        <div style="position: relative; top: -2px; left: -20px;">
                                            <label class="text">Reg Start</label>
                                            <input type="date" name="reg_start" class="custom-select-date" required value="<?= $_SESSION['dates_data']['reg_start'] ?? '' ?>">
                                        </div>
                                        <div style="position: relative; left: 10px; top: -2px;">
                                            <label class="text">Reg End</label>
                                            <input type="date" name="reg_end" class="custom-select-date" required value="<?= $_SESSION['dates_data']['reg_end'] ?? '' ?>">
                                        </div>
                                        <div style="position: relative; left: 40px; top: -2px;">
                                            <label class="text">Reg Fee</label>
                                            <input type="text" style="width: 90%;" name="reg_fee" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['reg_fee'] ?? '' ?>">
                                        </div>
                                        <div style="position: relative; left: 58px; top: -2px;">
                                            <label class="text">Programme Start</label>
                                            <input type="date" name="start" class="custom-select-date" required value="<?= $_SESSION['dates_data']['start'] ?? '' ?>">
                                        </div>
                                        <div style="position: relative; left: 60px; top: -2px;">
                                            <label class="text">Programme End</label>
                                            <input type="date" name="end" class="custom-select-date" required value="<?= $_SESSION['dates_data']['end'] ?? '' ?>">
                                        </div>    
                                    </div>
                                    
                                    <div style="display: flex; padding-top: 40px; margin-left: 80px; margin-right: 34px;">
                                        <div>
                                            <label class="text">Monthly  Fee</label>
                                            <input type="text" name="mfee" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['mfee'] ?? '' ?>">
                                        </div>  
                                        <div >
                                            <label class="text">Course Fee</label>
                                            <input type="text" name="cfee" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['cfee'] ?? '' ?>">
                                        </div>  
                                        <div style="position: relative; left: 16px;">
                                            <label class="text" style="width: 110%;">Elective Monthly</label>
                                            <input type="text" name="emonthly" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['emonthly'] ?? '' ?>">
                                        </div>  
                                        <div >
                                            <label class="text">Elective Total</label>
                                            <input type="text" name="etotal" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['etotal'] ?? '' ?>">
                                        </div> 
                                        <div style="position: relative; left: 8px;">
                                            <label class="text">Project Monthly</label>
                                            <input type="text" name="pmonthly" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['pmonthly'] ?? '' ?>">
                                        </div>  
                                        <div >
                                            <label class="text">Project Total</label>
                                            <input type="text" name="ptotal" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['ptotal'] ?? '' ?>">
                                        </div>                  
                                        
                                    </div>

                                    <div style="display: flex; padding-top: 40px; margin-left: 80px; margin-right: 8%;">
                                        <div >
                                            <label class="text">Total  Fee</label>
                                            <input type="text" name="fee" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['fee'] ?? '' ?>">
                                        </div>  
                                        <div style="position: relative; left: -18px;">
                                            <label class="text">Fee Discount</label>
                                            <input type="text" name="discount" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['discount'] ?? '' ?>">
                                        </div>               
                                        <div style="position: relative; left: -60px;">
                                            <label class="text">ShowDate From</label>
                                            <input type="text" name="showdatef" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['showdatef'] ?? '' ?>">
                                        </div>
                                        <div style="position: relative; left: -120px;">
                                            <label class="text">ShowDate To</label>
                                            <input type="text" name="showdate" class="custom-select-fee" placeholder="XXXXX" required value="<?= $_SESSION['dates_data']['showdate'] ?? '' ?>">
                                        </div>
                                        <div style="padding-bottom: 40px; padding-top: 26px; position: relative; left: -160px;">
                                            <input type="submit" name="add_dates" value="ADD ROW" class="add-row-btn">
                                        </div>                       
                                    </div> 
                                </div>
                            </div>
                        </form>

                        <!-- Fee Table -->
                        <?php if (isset($_SESSION['dates_data'])): ?>
                            <div style="padding-bottom: 50px; padding-left: 38px;">
                                <table>
                                    <thead>
                                        <tr style="background-color: #a10101; color: white;">
                                            <th>#</th>
                                            <th>Mode Of Learning</th>
                                            <th>Semester</th>
                                            <th>Reg Start</th>
                                            <th>Reg End</th>
                                            <th>Reg Fee</th>
                                            <th>Programme Start</th>
                                            <th>Programme End</th>
                                            <th>Monthly Fee</th>
                                            <th>Course Fee</th>
                                            <th>Elective Monthly</th>
                                            <th>Elective Total</th>
                                            <th>Project Monthly</th>
                                            <th>Project Total</th>
                                            <th>Total Fee</th>
                                            <th>Fee Discount</th>
                                            <th>ShowDate From</th>
                                            <th>ShowDate To</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                            <td></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['mode'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['semester'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['reg_start'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['reg_end'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['reg_fee'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['start'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['end'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['mfee'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['cfee'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['emonthly'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['etotal'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['pmonthly'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['ptotal'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['fee'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['discount'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['showdatef'] ?></td>
                                            <td contenteditable="true"><?= $_SESSION['dates_data']['showdate'] ?></td>
                                            <td style="background: none; border: none"><button class="update-btn">UPDATE</button></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Footer -->
                    <div class="container4" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                            <span style="color: white; font-weight: 600; ">
                                © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                const datesForm = document.getElementById("datesForm");
                const semesterInput = document.querySelector("input[name='semester']");

                if (datesForm && semesterInput) {
                    datesForm.addEventListener("submit", function (e) {
                        const pattern = /^(Fall|Spring|Summer)-(I|II)-\d{4}$/;
                        if (!pattern.test(semesterInput.value)) {
                            alert("Please enter the semester in format: Fall-I-2024 or Spring-II-2025.");
                            semesterInput.focus();
                            e.preventDefault();
                        }
                    });
                }
            });
        </script>
    </body>
</html>