<?php
    session_start();

    // Require user to be logged in
    if (!isset($_SESSION['username'])) {
        header("Location: LoginPage.php");
        exit();
    }

    // Check for session hijacking (IP address change)
    if (!isset($_SESSION['user_ip'])) {
        $_SESSION['user_ip'] = $_SERVER['REMOTE_ADDR'];
    } elseif ($_SESSION['user_ip'] !== $_SERVER['REMOTE_ADDR']) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }

    // Session timeout logic
    $timeout = 600; // 10 minutes
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        header("Location: LoginPage.php");
        exit();
    }
    $_SESSION['last_activity'] = time();

    // DB connection
    // $conn = new mysqli("localhost", "root", "", "nedacademy");
    // if ($conn->connect_error) {
    //     die("Connection failed: " . $conn->connect_error);
    // }

    include 'db.php';

    // Fetch certificate names
    $certificates = [];
    $result = $conn->query("SELECT id, certificate_name FROM certificates ORDER BY certificate_name ASC");
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $certificates[] = $row;
        }
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;600;700&display=swap"
        rel="stylesheet"
        />
        <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9"
        crossorigin="anonymous"
        />
        <link rel="stylesheet" href="assets/css/styles.css" />
        <title>NED ACADEMY</title>
    </head>
    <body>
        <div class="form-container">
            <div class="container" style="padding-top: 130px; padding-bottom: 100px">
                <div style="box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.3); border-radius: 26px; width: 110%; position: relative; left: -40px;">
                    <div class="container1">
                        <div style="text-align: left; background-color: white; border-top-left-radius: 20px; border-top-right-radius: 20px;">
                            <div class="py-2 text-left">
                                <img src="assets/img/ned logo.png" alt="ned logo" style="padding-top: 22px; width: 12%; padding-left: 20px;" />
                            </div>
                            <h2 class="py-2 text-center" style="color: rgba(28, 28, 78, 0.92); margin: -10px; font-size: xx-large; position: relative; top: 30px; font-weight: 700;">UPDATE STUDENT INFO</h2>
                            <div style="display: flex; justify-content: flex-end; padding: 10px;">
                                <button class="logout-btn" style="background: none; border: none;">
                                    <a href="Logout.php" style="color: rgba(28, 28, 78, 0.92); cursor: pointer; text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 15px; right: 10px;">
                                    LOGOUT
                                    </a>
                                </button>
                            </div>
                            <div style="padding-left: 30px;">
                                <button onclick="history.back()" style="cursor: pointer; background: none; border: none; color: rgba(28, 28, 78, 0.92); text-decoration: none; font-size: large; font-weight: 800; position: relative; bottom: 48px;">
                                    BACK
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="py-3 text-center container2">          
                        <div class="form-group">
                            <form name="myform" method="POST" action="searchvalues">
                                <input type="hidden" id="pagename" name="pagename" value="StudentDiscount">   
                                <div style="text-align: justify; padding: 50px;">
                                    <label class="text" >Certificate Name</label><br>
                                    <div style="padding-top: 10px">
                                        <select class="custom-select-course-name" id="course" name="course" required="">
                                        <option value="">Select</option>
                                            <?php foreach ($certificates as $cert): ?>
                                                <option value="<?= $cert['id'] ?>"><?= htmlspecialchars($cert['certificate_name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                                <div style="display: flex; justify-content: center; padding-bottom: 20px; position: relative; top: -10px;">
                                    <input type="submit" value="VIEW"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                                </div>
                            </form>

                            <?php if (!empty($selectedCertificateId)): ?>
                            <form action="setadmit" method="POST" onsubmit="return validate(this)">
                                <input type="hidden" id="programe1" name="programe1" value="Certificate">
                                <input type="hidden" id="yearid1" name="yearid1" value="null">
                                <input type="hidden" id="title1" name="title1" value="57866">
                                <input type="hidden" id="batchno1" name="batchno1" value="null">
                                <div style="padding: 50px; padding-top: 0px;">
                                    <table>
                                        <thead>
                                        <tr style="background-color: #a10101; color: white;">
                                            <th>Name</th>
                                            <th>CNIC</th>
                                            <th>Country</th>
                                            <th>Mobile No</th>
                                            <th>Whatsapp No</th>
                                            <th>Email</th>
                                            <th>Appear For Class</th>
                                            <th>Nomination Organization</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($students)): ?>
                                                <?php foreach ($students as $student): ?>
                                                    <tr style="text-align: center; border-bottom: 1px solid #ddd;">
                                                        <td><?= htmlspecialchars($student['student_name']) ?></td>
                                                        <td><?= htmlspecialchars($student['cnic']) ?></td>
                                                        <td><?= htmlspecialchars($student['country']) ?></td>
                                                        <td><?= htmlspecialchars($student['mobile_no']) ?></td>
                                                        <td><?= htmlspecialchars($student['whatsapp_no']) ?></td>
                                                        <td><?= htmlspecialchars($student['email']) ?></td>
                                                        <td><?= htmlspecialchars($student['appear_for_class']) ?></td>
                                                        <td><?= htmlspecialchars($student['nomination_organization']) ?></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                                <?php else: ?>
                                                <tr>
                                                    <td colspan="8" style="text-align:center; font-weight:bold; color:red;">
                                                        No Student Records found for the Selected Certificate.
                                                    </td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div style="display: flex; justify-content: center; padding-bottom: 20px; position: relative; top: -10px;">
                                    <input type="submit" value="UPDATE"
                                    style="background-color: rgb(161, 1, 1);padding: 12px 70px;border-radius: 70px;border: transparent;color: white;font-family: system-ui;font-weight: bolder;cursor: pointer;" />
                                </div>
                            </form>
                            <?php endif; ?>
                        </div>      
                    </div>
                    <!-- Footer -->
                    <div class="container4" style="background-color: maroon; border-bottom-left-radius: 20px; border-bottom-right-radius: 20px;">
                        <p style="font-size: 16px; padding-top: 32px; padding-bottom: 30px; text-align: center;">
                        <span style="color: white; font-weight: 600; ">
                            © Copyright NED Academy - NED University of Engineering &amp; Technology 2025. All Rights Reserved
                        </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>    
    </body>
</html>